/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.encrypt.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinosoftgz.starter.encrypt.advice.DecryptRequestBodyAdvice;
import com.sinosoftgz.starter.encrypt.advice.EncryptResponseBodyAdvice;
import com.sinosoftgz.starter.encrypt.api.EncryptKeyController;
import com.sinosoftgz.starter.encrypt.properties.EncryptProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={EncryptProperties.class})
@Import(value={EncryptKeyController.class})
@ConditionalOnProperty(value={"encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class EncryptConfiguration {
    private EncryptProperties encryptProperties;
    private ObjectMapper objectMapper;

    public EncryptConfiguration(EncryptProperties encryptProperties, ObjectMapper objectMapper) {
        this.encryptProperties = encryptProperties;
        this.objectMapper = objectMapper;
    }

    @Bean
    public EncryptResponseBodyAdvice encryptResponseBodyAdvice() {
        return new EncryptResponseBodyAdvice(this.objectMapper, this.encryptProperties);
    }

    @Bean
    public DecryptRequestBodyAdvice decryptRequestBodyAdvice() {
        return new DecryptRequestBodyAdvice(this.encryptProperties);
    }
}

