package com.sinosoftgz.starter.jasypt.api;

import com.sinosoftgz.starter.jasypt.constant.JasyptConstants;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;


/**
 * @author: Roney
 * @date: 2021-11-24 11:03
 * @description: JasyptToolController
 */
@RestController
@RequestMapping(JasyptConstants.APP_BASE_CONTEXT + "/jasypt")
public class JasyptToolController {
    private static final Logger log = LoggerFactory.getLogger(JasyptToolController.class);
    @Autowired
    private StringEncryptor stringEncryptor;

    /**
     * 此配置必须配置在环境变量或者配置中心，不允许配置在配置文件中
     */
    @Value("${jasypt.encryptor.password:SinosoftgzD4Krl#*@#%}")
    private String encryptorKey;

    /**
     * jasypt加密
     *
     * @param text    要加密的字符创
     * @param initKey 加密的密钥，防止恶意生成
     * @return
     */
    @RequestMapping(value = "/encrypt", method = RequestMethod.POST)
    @ResponseBody
    public String encrypt(@RequestParam(name = "text", required = true) String text, @RequestParam(name = "initKey", required = true) String initKey) {
        if (!StringUtils.hasLength(encryptorKey)) {
            log.info("密匙为空:{} ", text);
            return null;
        }

        if (!StringUtils.hasLength(text)) {
            log.info("原文不能为空:{} ", text);
            return null;
        }
        if (!initKey.equals(encryptorKey)) {
            log.info("密码错误:{} ", initKey);
            return null;
        }

        String encrypted = stringEncryptor.encrypt(text.trim());
        log.info("原文:{} ", text);
        log.info("加密: {}", encrypted);

        log.info("最终需要的加密串: {}", String.format("ENC(%s)", encrypted));
        return String.format("ENC(%s)", encrypted);
    }


}


