/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.config;

import com.sinosoftgz.starter.jwt.api.JwtController;
import com.sinosoftgz.starter.jwt.filter.JwtAuthenticationFilter;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={JwtProperties.class})
@Import(value={JwtController.class})
public class JwtConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JwtConfiguration.class);
    private JwtProperties jwtProperties;

    public JwtConfiguration(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    @PostConstruct
    public void afterConstruct() {
        log.info("\u5f00\u59cb\u914d\u7f6ejwt\uff0c\u5f53\u524d\u7684\u9ed8\u8ba4\u914d\u7f6e\u4e3a\uff1a{}", (Object)this.jwtProperties);
        if (this.jwtProperties.getMaxIdleMinute() < this.jwtProperties.getMaxAliveMinute()) {
            throw new IllegalArgumentException("accessToken\u7684maxIdleMinute\u5fc5\u987b\u5927\u4e8emaxAliveMinute\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.jwt", name={"enabled"}, havingValue="true", matchIfMissing=true)
    FilterRegistrationBean filterRegistrationBean() {
        JwtAuthenticationFilter filter = new JwtAuthenticationFilter(this.jwtUtils(), this.jwtProperties);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setUrlPatterns(this.jwtProperties.getUrlPatterns());
        return registrationBean;
    }

    @Bean
    JwtUtils jwtUtils() {
        return new JwtUtils(this.jwtProperties);
    }
}

