/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.filter;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class JwtAuthenticationFilter
implements Filter {
    private JwtUtils jwtUtils;
    private JwtProperties jwtProperties;
    PathMatcher matcher = new AntPathMatcher();

    public JwtAuthenticationFilter(JwtUtils jwtUtils, JwtProperties jwtProperties) {
        this.jwtUtils = jwtUtils;
        this.jwtProperties = jwtProperties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.excludeUrls(request, response, filterChain)) {
            return;
        }
        String token = this.getJwtToken(request);
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.forbidden(response);
            return;
        }
        if (!this.jwtUtils.expire(token)) {
            this.forbidden(response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void forbidden(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString((Object)BaseResponse.forbidden((String)CommonResponseCodeEnum.FORBIDDEN.getResultMsg())));
        writer.flush();
        writer.close();
    }

    public void destroy() {
    }

    private String getJwtToken(HttpServletRequest request) {
        String token = request.getHeader(this.jwtProperties.getHeaderKeyOfToken());
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getParameter(this.jwtProperties.getHeaderKeyOfToken());
        }
        return token;
    }

    private boolean excludeUrls(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestUrl = request.getRequestURI();
        for (String excludeUrl : this.jwtProperties.getUrlExcludes()) {
            excludeUrl = request.getContextPath() + excludeUrl;
            if (this.matcher.match(excludeUrl, requestUrl)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            if (requestUrl.indexOf(excludeUrl) <= -1) continue;
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }
}

