/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.properties;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@ConfigurationProperties(prefix="spring.jwt")
@RefreshScope
public class JwtProperties {
    public static final String JWT_PREFIX = "spring.jwt";
    private boolean enabled;
    List<String> urlPatterns = Arrays.asList("/*");
    List<String> urlExcludes;
    private int maxAliveMinute = 30;
    private int maxIdleMinute = 60;
    private String headerKeyOfToken = "jwt-token";
    private String accountAlias = "account";
    private boolean enableAutoRefreshToken = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public List<String> getUrlExcludes() {
        return this.urlExcludes;
    }

    public int getMaxAliveMinute() {
        return this.maxAliveMinute;
    }

    public int getMaxIdleMinute() {
        return this.maxIdleMinute;
    }

    public String getHeaderKeyOfToken() {
        return this.headerKeyOfToken;
    }

    public String getAccountAlias() {
        return this.accountAlias;
    }

    public boolean isEnableAutoRefreshToken() {
        return this.enableAutoRefreshToken;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrlPatterns(List<String> urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public void setUrlExcludes(List<String> urlExcludes) {
        this.urlExcludes = urlExcludes;
    }

    public void setMaxAliveMinute(int maxAliveMinute) {
        this.maxAliveMinute = maxAliveMinute;
    }

    public void setMaxIdleMinute(int maxIdleMinute) {
        this.maxIdleMinute = maxIdleMinute;
    }

    public void setHeaderKeyOfToken(String headerKeyOfToken) {
        this.headerKeyOfToken = headerKeyOfToken;
    }

    public void setAccountAlias(String accountAlias) {
        this.accountAlias = accountAlias;
    }

    public void setEnableAutoRefreshToken(boolean enableAutoRefreshToken) {
        this.enableAutoRefreshToken = enableAutoRefreshToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtProperties)) {
            return false;
        }
        JwtProperties other = (JwtProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<String> this$urlPatterns = this.getUrlPatterns();
        List<String> other$urlPatterns = other.getUrlPatterns();
        if (this$urlPatterns == null ? other$urlPatterns != null : !((Object)this$urlPatterns).equals(other$urlPatterns)) {
            return false;
        }
        List<String> this$urlExcludes = this.getUrlExcludes();
        List<String> other$urlExcludes = other.getUrlExcludes();
        if (this$urlExcludes == null ? other$urlExcludes != null : !((Object)this$urlExcludes).equals(other$urlExcludes)) {
            return false;
        }
        if (this.getMaxAliveMinute() != other.getMaxAliveMinute()) {
            return false;
        }
        if (this.getMaxIdleMinute() != other.getMaxIdleMinute()) {
            return false;
        }
        String this$headerKeyOfToken = this.getHeaderKeyOfToken();
        String other$headerKeyOfToken = other.getHeaderKeyOfToken();
        if (this$headerKeyOfToken == null ? other$headerKeyOfToken != null : !this$headerKeyOfToken.equals(other$headerKeyOfToken)) {
            return false;
        }
        String this$accountAlias = this.getAccountAlias();
        String other$accountAlias = other.getAccountAlias();
        if (this$accountAlias == null ? other$accountAlias != null : !this$accountAlias.equals(other$accountAlias)) {
            return false;
        }
        return this.isEnableAutoRefreshToken() == other.isEnableAutoRefreshToken();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<String> $urlPatterns = this.getUrlPatterns();
        result = result * 59 + ($urlPatterns == null ? 43 : ((Object)$urlPatterns).hashCode());
        List<String> $urlExcludes = this.getUrlExcludes();
        result = result * 59 + ($urlExcludes == null ? 43 : ((Object)$urlExcludes).hashCode());
        result = result * 59 + this.getMaxAliveMinute();
        result = result * 59 + this.getMaxIdleMinute();
        String $headerKeyOfToken = this.getHeaderKeyOfToken();
        result = result * 59 + ($headerKeyOfToken == null ? 43 : $headerKeyOfToken.hashCode());
        String $accountAlias = this.getAccountAlias();
        result = result * 59 + ($accountAlias == null ? 43 : $accountAlias.hashCode());
        result = result * 59 + (this.isEnableAutoRefreshToken() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JwtProperties(enabled=" + this.isEnabled() + ", urlPatterns=" + this.getUrlPatterns() + ", urlExcludes=" + this.getUrlExcludes() + ", maxAliveMinute=" + this.getMaxAliveMinute() + ", maxIdleMinute=" + this.getMaxIdleMinute() + ", headerKeyOfToken=" + this.getHeaderKeyOfToken() + ", accountAlias=" + this.getAccountAlias() + ", enableAutoRefreshToken=" + this.isEnableAutoRefreshToken() + ")";
    }
}

