/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Strings;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.utils.lang.Lang;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private final JwtProperties jwtProperties;

    public JwtUtils(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    public boolean destroyToken(String token, String secret) {
        if (!this.verify(token, secret)) {
            return true;
        }
        return true;
    }

    public DecodedJWT renewalToken(String token, String secret) {
        if (Lang.isEmpty((Object)this.verifySafetyPeriod(token, secret))) {
            return null;
        }
        String newToken = this.sign(this.getAccount(token), secret);
        DecodedJWT jwt = this.checkToken(newToken, secret);
        return jwt;
    }

    public DecodedJWT verifySafetyPeriod(String token, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).acceptExpiresAt((long)(this.jwtProperties.getMaxIdleMinute() * 60)).build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt;
        }
        catch (Exception exception) {
            log.error("verify token error", (Throwable)exception);
            return null;
        }
    }

    public boolean verify(String token, String secret) {
        DecodedJWT jwt = this.checkToken(token, secret);
        return !Lang.isEmpty((Object)jwt);
    }

    public DecodedJWT checkToken(String token, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim(this.jwtProperties.getAccountAlias(), this.getAccount(token)).build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt;
        }
        catch (Exception exception) {
            log.error("verify token error", (Throwable)exception);
            return null;
        }
    }

    public String getAccount(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            return null;
        }
        DecodedJWT jwt = this.decode(token);
        if (jwt != null) {
            return jwt.getClaim(this.jwtProperties.getAccountAlias()).asString();
        }
        return null;
    }

    public String sign(String account, String secret, long expireAfterMinutes) {
        if (Lang.isEmpty((Object)expireAfterMinutes)) {
            expireAfterMinutes = this.jwtProperties.getMaxAliveMinute();
        }
        Date expireAfter = new Date(System.currentTimeMillis() + expireAfterMinutes * 60L * 1000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim(this.jwtProperties.getAccountAlias(), account).withExpiresAt(expireAfter).sign(algorithm);
    }

    public String sign(String account, String secret) {
        return this.sign(account, secret, this.jwtProperties.getMaxAliveMinute());
    }

    public boolean expire(String token) {
        DecodedJWT jwt = this.decode(token);
        return jwt != null && jwt.getExpiresAt().getTime() > System.currentTimeMillis();
    }

    private DecodedJWT decode(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt;
        }
        catch (Exception e) {
            log.error("decode token error", (Throwable)e);
            return null;
        }
    }
}

