package com.sinosoftgz.starter.jwt.api;

import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.model.JwtToken;
import com.sinosoftgz.starter.jwt.model.JwtUserInfo;

/**
 * Jwt接口
 *
 * @author: Roney
 * @date: 2022-06-07 12:03
 * @description: Jwt接口
 * 各个业务方实现接口，默认是http协议，后续可以增加RPC等协议，由各个业务系统技术栈决定
 */
public interface JwtApi {

    /**
     * 创建token
     *
     * @param jwtUserInfo
     * @return
     */
    public JwtPrincipal createToken(JwtUserInfo jwtUserInfo);

    /**
     * 校验token
     *
     * @param jwtToken
     * @return
     */
    public boolean verify(JwtToken jwtToken);


    /**
     * 续期token
     *
     * @param jwtToken
     * @return
     */
    public JwtPrincipal renewalToken(JwtToken jwtToken);

    /**
     * 销毁token 用户可能将token放入redis中，注销时，需要清除redis缓存
     *
     * @param jwtToken
     * @return
     */
    public boolean destroyToken(JwtToken jwtToken);


    /**
     * 根据token获取账号
     *
     * @param token
     * @return
     */
    public String getAccount(String token);

    /**
     * 校验token是否过期
     *
     * @param token
     * @return
     */
    public boolean expire(String token);
}
