package com.sinosoftgz.starter.jwt.api.impl;

import com.sinosoftgz.starter.jwt.api.JwtApi;
import com.sinosoftgz.starter.jwt.biz.JwtAuthBiz;
import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.model.JwtToken;
import com.sinosoftgz.starter.jwt.model.JwtUserInfo;

import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * jwt http 协议接口实现
 *
 * @author Roney
 * @date 2021/1/4 21:42
 */
@RestController
@RequestMapping("/auth/jwt")
public class JwtController implements JwtApi {

    @Resource
    JwtAuthBiz jwtAuthBiz;

    @PostMapping("/createToken")
    @Override
    public JwtPrincipal createToken(@Valid @RequestBody JwtUserInfo jwtUserInfo) {
        return jwtAuthBiz.createToken(jwtUserInfo);
    }

    @Override
    @PostMapping("/verify")
    public boolean verify(@Valid @RequestBody JwtToken jwtToken) {
        return jwtAuthBiz.verify(jwtToken);
    }

    @Override
    @PostMapping("/renewalToken")
    public JwtPrincipal renewalToken(@Valid @RequestBody JwtToken jwtToken) {
        return jwtAuthBiz.renewalToken(jwtToken);
    }

    @Override
    @PostMapping("/destroyToken")
    public boolean destroyToken(@Valid @RequestBody JwtToken jwtToken) {
        return jwtAuthBiz.destroyToken(jwtToken);
    }

    @Override
    @PostMapping("/getAccount")
    public String getAccount(@RequestParam(name = "token", required = true) String token) {
        return jwtAuthBiz.getAccount(token);
    }

    @Override
    @PostMapping("/expire")
    public boolean expire(@RequestParam(name = "token", required = true) String token) {
        return jwtAuthBiz.expire(token);
    }

}
