package com.sinosoftgz.starter.jwt.biz.impl;

import com.sinosoftgz.global.common.constants.CommonConstants;
import com.sinosoftgz.starter.jwt.biz.JwtAuthBiz;
import com.sinosoftgz.starter.jwt.model.JwtToken;
import com.sinosoftgz.starter.jwt.model.JwtUserInfo;
import org.springframework.util.Assert;

/**
 * JwtAuthBiz抽象类
 *
 * @author: Roney
 * @date: 2022-06-07 16:13
 * @description:
 */
public abstract class AbstractJwtAuthBizImpl implements JwtAuthBiz {

    /**
     * 校验参数
     *
     * @param jwtUserInfo
     */
    public void checkJwtUserInfo(JwtUserInfo jwtUserInfo) {
        Assert.notNull(jwtUserInfo, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        Assert.notNull(jwtUserInfo.getAccount(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "account"));
        Assert.notNull(jwtUserInfo.getSecret(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "secret"));
    }

    /**
     * 校验参数
     *
     * @param jwtToken
     */
    public void checkJwtToken(JwtToken jwtToken) {
        Assert.notNull(jwtToken, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        Assert.notNull(jwtToken.getToken(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "token"));
        Assert.notNull(jwtToken.getSecret(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "secret"));
    }

    /**
     * 校验参数
     *
     * @param token
     */
    public void checkToken(String token) {
        Assert.notNull(token, String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "token"));
    }
}
