package com.sinosoftgz.starter.jwt.config;

import com.sinosoftgz.starter.jwt.api.impl.JwtController;
import com.sinosoftgz.starter.jwt.filter.JwtAuthenticationFilter;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * Created by Roney on 2021/1/4 20:23.
 */
@Configuration
@EnableConfigurationProperties({JwtProperties.class})
@Import({
        JwtController.class
})
@Slf4j
public class JwtConfiguration {

    private JwtProperties jwtProperties;


    public JwtConfiguration(final JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    @PostConstruct
    public void afterConstruct() {
        log.info("开始配置jwt，当前的默认配置为：{}", jwtProperties);
        if (jwtProperties.getMaxIdleMinute() < jwtProperties.getMaxAliveMinute()) {
            throw new IllegalArgumentException("accessToken的maxIdleMinute必须大于maxAliveMinute，请检查配置");
        }
    }


    @Bean
    @ConditionalOnProperty(prefix = JwtProperties.JWT_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
    FilterRegistrationBean filterRegistrationBean() {
        JwtAuthenticationFilter filter = new JwtAuthenticationFilter(jwtUtils(), jwtProperties);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean(filter);
        registrationBean.setUrlPatterns(jwtProperties.getUrlPatterns());
        return registrationBean;
    }

    @Bean
    JwtUtils jwtUtils() {
        return new JwtUtils(jwtProperties);
    }
}
