package com.sinosoftgz.starter.jwt.model;

import lombok.Data;

/**
 * 用于存储登录用户的信息
 * Created by Roney on 2021/1/5 13:59.
 */
@Data
public class JwtPrincipal {

    /**
     * 用户信息
     */
    private String account;

    /**
     * 有效期
     */
    private long expiresAt;

    /**
     * token值
     */
    private String token;

    public JwtPrincipal() {

    }

    public JwtPrincipal(long expiresAt, String token) {
        this.expiresAt = expiresAt;
        this.token = token;
    }

    public JwtPrincipal(String account, long expiresAt, String token) {
        this.account = account;
        this.expiresAt = expiresAt;
        this.token = token;
    }
}
