package com.sinosoftgz.starter.jwt.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * Created by Roney on 2021/1/4 20:54.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class JwtUserInfo {

    /**
     * 用户的唯一标识
     */
    @NotNull
    private String account;

    /**
     * accessToken的密钥，用于对accessToken进行加密和解密
     * 建议为每个用户配置不同的密钥（比如使用用户的password）
     */
    @NotNull
    private String secret;
}
