package com.sinosoftgz.starter.jwt.properties;

import com.sinosoftgz.starter.jwt.constant.JwtConstants;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import java.util.Arrays;
import java.util.List;

/**
 * @author Roney
 * @date 2021/1/4 20:30
 */
@Data
@ConfigurationProperties(prefix = JwtProperties.JWT_PREFIX)
@RefreshScope
public class JwtProperties {

    public static final String JWT_PREFIX = "spring.jwt";


    private boolean enabled;
    /**
     * 需要拦截的url地址，默认拦截所有 /**
     */
    private List<String> urlPatterns = Arrays.asList("/*");
    /**
     * 需要排除那些url地址，默认无
     */
    private List<String> urlExcludes;

    /**
     * accessToken的理论过期时间，单位分钟，token如果超过该时间则接口响应的header中附带新的token信息
     */
    private int maxAliveMinute = 30;

    /**
     * accessToken的最大生存周期，单位分钟，在此时间内的token无需重新登录即可刷新
     */
    private int maxIdleMinute = 60;

    /**
     * accessToken在http header中的name
     */
    private String headerKeyOfToken = "jwt-token";

    /**
     * token中保存的用户名的key name
     */
    private String accountAlias = "account";

    /**
     * 是否启用token的自动刷新机制
     */
    private boolean enableAutoRefreshToken = false;


    /**
     * 是否启用mock数据
     */
    private boolean enableMock = false;

    /**
     * mock默认账号列表
     */
    private List<String> mockAccounts = JwtConstants.defaultAccounts;


    /**
     * mock密钥列表
     */
    private List<String> mockSecrets = JwtConstants.defaultSecrets;
}
