/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.api.impl;

import com.sinosoftgz.starter.jwt.api.JwtApi;
import com.sinosoftgz.starter.jwt.biz.JwtAuthBiz;
import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.model.JwtToken;
import com.sinosoftgz.starter.jwt.model.JwtUserInfo;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth/jwt"})
public class JwtController
implements JwtApi {
    @Resource
    JwtAuthBiz jwtAuthBiz;

    @Override
    @PostMapping(value={"/createToken"})
    public JwtPrincipal createToken(@Valid @RequestBody JwtUserInfo jwtUserInfo) {
        return this.jwtAuthBiz.createToken(jwtUserInfo);
    }

    @Override
    @PostMapping(value={"/verify"})
    public boolean verify(@Valid @RequestBody JwtToken jwtToken) {
        return this.jwtAuthBiz.verify(jwtToken);
    }

    @Override
    @PostMapping(value={"/renewalToken"})
    public JwtPrincipal renewalToken(@Valid @RequestBody JwtToken jwtToken) {
        return this.jwtAuthBiz.renewalToken(jwtToken);
    }

    @Override
    @PostMapping(value={"/destroyToken"})
    public boolean destroyToken(@Valid @RequestBody JwtToken jwtToken) {
        return this.jwtAuthBiz.destroyToken(jwtToken);
    }

    @Override
    @PostMapping(value={"/getAccount"})
    public String getAccount(@RequestParam(name="token", required=true) String token) {
        return this.jwtAuthBiz.getAccount(token);
    }

    @Override
    @PostMapping(value={"/expire"})
    public boolean expire(@RequestParam(name="token", required=true) String token) {
        return this.jwtAuthBiz.expire(token);
    }
}

