/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.biz.impl;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sinosoftgz.starter.jwt.biz.impl.AbstractJwtAuthBizImpl;
import com.sinosoftgz.starter.jwt.model.JwtPrincipal;
import com.sinosoftgz.starter.jwt.model.JwtToken;
import com.sinosoftgz.starter.jwt.model.JwtUserInfo;
import com.sinosoftgz.starter.jwt.utils.JwtUtils;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="mockJwtAuthBizImpl")
@ConditionalOnProperty(prefix="spring.jwt", name={"enableMock"}, havingValue="true", matchIfMissing=false)
public class MockJwtAuthBizImpl
extends AbstractJwtAuthBizImpl {
    private static final Logger log = LoggerFactory.getLogger(MockJwtAuthBizImpl.class);
    @Resource
    JwtUtils jwtUtils;

    @Override
    public JwtPrincipal createToken(JwtUserInfo jwtUserInfo) {
        this.checkJwtUserInfo(jwtUserInfo);
        String token = this.jwtUtils.sign(jwtUserInfo.getAccount(), jwtUserInfo.getSecret());
        long expiresAt = this.jwtUtils.getExpiresAt(token);
        String account = this.jwtUtils.getAccount(token);
        return new JwtPrincipal(account, expiresAt, token);
    }

    @Override
    public boolean verify(JwtToken jwtToken) {
        this.checkJwtToken(jwtToken);
        return this.jwtUtils.verify(jwtToken.getToken(), jwtToken.getSecret());
    }

    @Override
    public JwtPrincipal renewalToken(JwtToken jwtToken) {
        this.checkJwtToken(jwtToken);
        DecodedJWT decodedJWT = this.jwtUtils.renewalToken(jwtToken.getToken(), jwtToken.getSecret());
        if (!Objects.isNull(decodedJWT)) {
            String token = decodedJWT.getToken();
            long expiresAt = decodedJWT.getExpiresAt().getTime();
            String account = this.jwtUtils.getAccount(token);
            return new JwtPrincipal(account, expiresAt, token);
        }
        return new JwtPrincipal();
    }

    @Override
    public boolean destroyToken(JwtToken jwtToken) {
        this.checkJwtToken(jwtToken);
        return this.jwtUtils.destroyToken(jwtToken.getToken(), jwtToken.getSecret());
    }

    @Override
    public String getAccount(String token) {
        this.checkToken(token);
        return this.jwtUtils.getAccount(token);
    }

    @Override
    public boolean expire(String token) {
        this.checkToken(token);
        return this.jwtUtils.expire(token);
    }
}

