/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.properties;

import com.sinosoftgz.starter.jwt.constant.JwtConstants;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@ConfigurationProperties(prefix="spring.jwt")
@RefreshScope
public class JwtProperties {
    public static final String JWT_PREFIX = "spring.jwt";
    private boolean enabled;
    private List<String> urlPatterns = Arrays.asList("/*");
    private List<String> urlExcludes;
    private int maxAliveMinute = 30;
    private int maxIdleMinute = 60;
    private String headerKeyOfToken = "jwt-token";
    private String accountAlias = "account";
    private boolean enableAutoRefreshToken = false;
    private boolean enableMock = false;
    private List<String> mockAccounts = JwtConstants.defaultAccounts;
    private List<String> mockSecrets = JwtConstants.defaultSecrets;

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public List<String> getUrlExcludes() {
        return this.urlExcludes;
    }

    public int getMaxAliveMinute() {
        return this.maxAliveMinute;
    }

    public int getMaxIdleMinute() {
        return this.maxIdleMinute;
    }

    public String getHeaderKeyOfToken() {
        return this.headerKeyOfToken;
    }

    public String getAccountAlias() {
        return this.accountAlias;
    }

    public boolean isEnableAutoRefreshToken() {
        return this.enableAutoRefreshToken;
    }

    public boolean isEnableMock() {
        return this.enableMock;
    }

    public List<String> getMockAccounts() {
        return this.mockAccounts;
    }

    public List<String> getMockSecrets() {
        return this.mockSecrets;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrlPatterns(List<String> urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public void setUrlExcludes(List<String> urlExcludes) {
        this.urlExcludes = urlExcludes;
    }

    public void setMaxAliveMinute(int maxAliveMinute) {
        this.maxAliveMinute = maxAliveMinute;
    }

    public void setMaxIdleMinute(int maxIdleMinute) {
        this.maxIdleMinute = maxIdleMinute;
    }

    public void setHeaderKeyOfToken(String headerKeyOfToken) {
        this.headerKeyOfToken = headerKeyOfToken;
    }

    public void setAccountAlias(String accountAlias) {
        this.accountAlias = accountAlias;
    }

    public void setEnableAutoRefreshToken(boolean enableAutoRefreshToken) {
        this.enableAutoRefreshToken = enableAutoRefreshToken;
    }

    public void setEnableMock(boolean enableMock) {
        this.enableMock = enableMock;
    }

    public void setMockAccounts(List<String> mockAccounts) {
        this.mockAccounts = mockAccounts;
    }

    public void setMockSecrets(List<String> mockSecrets) {
        this.mockSecrets = mockSecrets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtProperties)) {
            return false;
        }
        JwtProperties other = (JwtProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxAliveMinute() != other.getMaxAliveMinute()) {
            return false;
        }
        if (this.getMaxIdleMinute() != other.getMaxIdleMinute()) {
            return false;
        }
        if (this.isEnableAutoRefreshToken() != other.isEnableAutoRefreshToken()) {
            return false;
        }
        if (this.isEnableMock() != other.isEnableMock()) {
            return false;
        }
        List<String> this$urlPatterns = this.getUrlPatterns();
        List<String> other$urlPatterns = other.getUrlPatterns();
        if (this$urlPatterns == null ? other$urlPatterns != null : !((Object)this$urlPatterns).equals(other$urlPatterns)) {
            return false;
        }
        List<String> this$urlExcludes = this.getUrlExcludes();
        List<String> other$urlExcludes = other.getUrlExcludes();
        if (this$urlExcludes == null ? other$urlExcludes != null : !((Object)this$urlExcludes).equals(other$urlExcludes)) {
            return false;
        }
        String this$headerKeyOfToken = this.getHeaderKeyOfToken();
        String other$headerKeyOfToken = other.getHeaderKeyOfToken();
        if (this$headerKeyOfToken == null ? other$headerKeyOfToken != null : !this$headerKeyOfToken.equals(other$headerKeyOfToken)) {
            return false;
        }
        String this$accountAlias = this.getAccountAlias();
        String other$accountAlias = other.getAccountAlias();
        if (this$accountAlias == null ? other$accountAlias != null : !this$accountAlias.equals(other$accountAlias)) {
            return false;
        }
        List<String> this$mockAccounts = this.getMockAccounts();
        List<String> other$mockAccounts = other.getMockAccounts();
        if (this$mockAccounts == null ? other$mockAccounts != null : !((Object)this$mockAccounts).equals(other$mockAccounts)) {
            return false;
        }
        List<String> this$mockSecrets = this.getMockSecrets();
        List<String> other$mockSecrets = other.getMockSecrets();
        return !(this$mockSecrets == null ? other$mockSecrets != null : !((Object)this$mockSecrets).equals(other$mockSecrets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxAliveMinute();
        result = result * 59 + this.getMaxIdleMinute();
        result = result * 59 + (this.isEnableAutoRefreshToken() ? 79 : 97);
        result = result * 59 + (this.isEnableMock() ? 79 : 97);
        List<String> $urlPatterns = this.getUrlPatterns();
        result = result * 59 + ($urlPatterns == null ? 43 : ((Object)$urlPatterns).hashCode());
        List<String> $urlExcludes = this.getUrlExcludes();
        result = result * 59 + ($urlExcludes == null ? 43 : ((Object)$urlExcludes).hashCode());
        String $headerKeyOfToken = this.getHeaderKeyOfToken();
        result = result * 59 + ($headerKeyOfToken == null ? 43 : $headerKeyOfToken.hashCode());
        String $accountAlias = this.getAccountAlias();
        result = result * 59 + ($accountAlias == null ? 43 : $accountAlias.hashCode());
        List<String> $mockAccounts = this.getMockAccounts();
        result = result * 59 + ($mockAccounts == null ? 43 : ((Object)$mockAccounts).hashCode());
        List<String> $mockSecrets = this.getMockSecrets();
        result = result * 59 + ($mockSecrets == null ? 43 : ((Object)$mockSecrets).hashCode());
        return result;
    }

    public String toString() {
        return "JwtProperties(enabled=" + this.isEnabled() + ", urlPatterns=" + this.getUrlPatterns() + ", urlExcludes=" + this.getUrlExcludes() + ", maxAliveMinute=" + this.getMaxAliveMinute() + ", maxIdleMinute=" + this.getMaxIdleMinute() + ", headerKeyOfToken=" + this.getHeaderKeyOfToken() + ", accountAlias=" + this.getAccountAlias() + ", enableAutoRefreshToken=" + this.isEnableAutoRefreshToken() + ", enableMock=" + this.isEnableMock() + ", mockAccounts=" + this.getMockAccounts() + ", mockSecrets=" + this.getMockSecrets() + ")";
    }
}

