/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jwt.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Preconditions;
import com.sinosoftgz.starter.jwt.exception.JwtAccountException;
import com.sinosoftgz.starter.jwt.exception.JwtVerificationFailedException;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.utils.lang.Lang;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private final JwtProperties jwtProperties;

    public JwtUtils(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    public boolean destroyToken(String token, String secret) {
        return !this.verify(token, secret);
    }

    public DecodedJWT renewalToken(String token, String secret) {
        if (Lang.isEmpty((Object)this.verifySafetyPeriod(token, secret))) {
            throw new JwtVerificationFailedException("token\u5df2\u7ecf\u8fc7\u671f\uff0c\u65e0\u6cd5\u7eed\u7b7e");
        }
        String newToken = this.sign(this.getAccount(token), secret);
        DecodedJWT jwt = this.checkToken(newToken, secret);
        return jwt;
    }

    public DecodedJWT verifySafetyPeriod(String token, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).acceptExpiresAt((long)(this.jwtProperties.getMaxIdleMinute() * 60)).build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt;
        }
        catch (Exception exception) {
            log.error("verify token error", (Throwable)exception);
            throw new JwtVerificationFailedException("verify token error");
        }
    }

    public boolean verify(String token, String secret) {
        DecodedJWT jwt = this.checkToken(token, secret);
        return !Lang.isEmpty((Object)jwt);
    }

    public DecodedJWT checkToken(String token, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim(this.jwtProperties.getAccountAlias(), this.getAccount(token)).build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt;
        }
        catch (Exception exception) {
            log.error("verify token error", (Throwable)exception);
            throw new JwtVerificationFailedException("\u6821\u9a8ctoken\u5f02\u5e38");
        }
    }

    public String getAccount(String token) {
        Preconditions.checkNotNull((Object)token, (Object)String.format("%s must be have value!", "token"));
        DecodedJWT jwt = this.decode(token);
        if (jwt != null) {
            return jwt.getClaim(this.jwtProperties.getAccountAlias()).asString();
        }
        throw new JwtAccountException("\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38");
    }

    public String sign(String account, String secret, long expireAfterMinutes) {
        Preconditions.checkNotNull((Object)account, (Object)String.format("%s must be have value!", "account"));
        Preconditions.checkNotNull((Object)secret, (Object)String.format("%s must be have value!", "secret"));
        if (Lang.isEmpty((Object)expireAfterMinutes)) {
            expireAfterMinutes = this.jwtProperties.getMaxAliveMinute();
        }
        Date expireAfter = new Date(System.currentTimeMillis() + expireAfterMinutes * 60L * 1000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim(this.jwtProperties.getAccountAlias(), account).withExpiresAt(expireAfter).sign(algorithm);
    }

    public String sign(String account, String secret) {
        Preconditions.checkNotNull((Object)account, (Object)String.format("%s must be have value!", "account"));
        Preconditions.checkNotNull((Object)secret, (Object)String.format("%s must be have value!", "secret"));
        return this.sign(account, secret, this.jwtProperties.getMaxAliveMinute());
    }

    public boolean expire(String token) {
        Preconditions.checkNotNull((Object)token, (Object)String.format("%s must be have value!", "token"));
        DecodedJWT jwt = this.decode(token);
        return jwt != null && jwt.getExpiresAt().getTime() > System.currentTimeMillis();
    }

    public long getExpiresAt(String token) {
        Preconditions.checkNotNull((Object)token, (Object)String.format("%s must be have value!", "token"));
        DecodedJWT jwt = this.decode(token);
        if (jwt != null) {
            return jwt.getExpiresAt().getTime();
        }
        return -1L;
    }

    private DecodedJWT decode(String token) {
        Preconditions.checkNotNull((Object)token, (Object)String.format("%s must be have value!", "token"));
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt;
        }
        catch (Exception e) {
            log.error("decode token error", (Throwable)e);
            throw new JWTDecodeException("decode token error");
        }
    }
}

