package com.sinosoftgz.starter.shiro.jwt.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.sinosoftgz.starter.jwt.properties.JwtProperties;
import com.sinosoftgz.starter.shiro.biz.ShiroUserBiz;
import com.sinosoftgz.starter.shiro.filter.ShiroAccessControlFilter;
import com.sinosoftgz.starter.shiro.jwt.support.JWTToken;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by Roney on 2021/1/5 16:27.
 */
public class ShiroJwtAccessControlFilter extends AccessControlFilter {

    private static final Logger logger = LoggerFactory.getLogger(ShiroJwtAccessControlFilter.class);

    @Autowired
    ShiroUserBiz shiroUserBiz;

    private JwtProperties jwtProperties;

    public ShiroJwtAccessControlFilter(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        //从header或URL参数中查找token
        HttpServletRequest req = (HttpServletRequest) request;
        String authorization = req.getHeader(jwtProperties.getHeaderKeyOfToken());
        if (Strings.isNullOrEmpty(authorization)) {
            authorization = req.getParameter(jwtProperties.getHeaderKeyOfToken());
        }
        JWTToken token = new JWTToken(authorization);
        try {
            getSubject(request, response).login(token);
        } catch (Exception e) {
            logger.error("认证失败:" + e.getMessage());
            returnLoginError(response);
            return false;
        }
        return true;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        return false;
    }

    /***
     * 登录失败时默认返回401状态码
     * @param response
     * @throws IOException
     */
    public void returnLoginError(ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString(shiroUserBiz.onAuthenticationFailed()));
    }


}
