package com.sinosoftgz.starter.shiro.jwt.model;

import lombok.Data;

import java.util.List;
import java.util.Set;

/**
 * Created by Roney on 2021/1/5 16:44.
 */

@Data
public class UserInfo {

    /**
     * 用户的唯一标识
     */
    private String account;

    /**
     * accessToken的密钥，用于对accessToken进行加密和解密
     * 建议为每个用户配置不同的密钥（比如使用用户的password）
     */
    private String secret;

    /**
     * 用户权限集合，含义类似于Shiro中的perms
     */
    private Set<String> permissions;

    /**
     * 用户角色
     */
    private Set<String> roles;
}
