package com.sinosoftgz.starter.shiro.biz;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import com.sinosoftgz.starter.shiro.model.ShiroUserInfo;

/**
 * Created by Roney on 2021/1/4 17:14.
 */
public interface ShiroUserBiz {
    /**
     * 通过令牌获取会话用户信息
     *
     * @param accessToken 登录令牌
     * @return 用户会话对象
     */
    ShiroUserInfo getUserInfo(String accessToken);

    /**
     * 创建accessToken，注意创建后放入缓存，并设置过期时间
     *
     * @param shiroUserInfo
     * @return
     */
    String createAccessToken(ShiroUserInfo shiroUserInfo);

    /**
     * 删除缓存的会话信息
     *
     * @param accessToken
     */
    void logout(String accessToken);

    /**
     * 自定义访问资源认证失败时的处理方式，例如返回json格式的错误信息
     * {\"code\":40001,\"message\":\"用户认证失败！\")
     *
     * @return 登录失败返回给接口一个对象信息
     */
    default BaseResponse onAuthenticationFailed() {
        return BaseResponse.unauthorized(CommonResponseCodeEnum.UNAUTHORIZED.getResultMsg());
    }

    /**
     * 自定义访问资源权限不足时的处理方式，例如返回json格式的错误信息
     * {\"code\":40003,\"message\":\"permission denied！\")
     *
     * @return 登录失败返回给接口一个对象信息
     */
    default BaseResponse onAuthorizationFailed() {
        return BaseResponse.forbidden(CommonResponseCodeEnum.FORBIDDEN.getResultMsg());
    }


}
