package com.sinosoftgz.starter.shiro.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import java.util.Arrays;
import java.util.List;

/**
 * 无状态 shiro 配置
 * Created by Roney on 2021/1/4 17:04.
 */
@ConfigurationProperties(prefix = ShiroProperties.SHIRO_PREFIX)
@Data
@RefreshScope
public class ShiroProperties {
    public static final String SHIRO_PREFIX = "spring.shiro";

    public boolean enabled;

    /**
     * 需要拦截的url地址，默认拦截所有 /**
     */
    public List<String> urlPatterns = Arrays.asList("/**");
    /**
     * 需要排除那些url地址，默认无
     */
    public List<String> urlExcludes;
    /**
     * token名称（通过参数或者header获取，优先取header里面的）
     */
    public String tokenName = "accessToken";

    /**
     * 是否禁用session
     * 默认禁用
     */
    public boolean sessionEnabled = false;
}
