package com.sinosoftgz.starter.shiro.support;

import com.sinosoftgz.starter.shiro.properties.ShiroProperties;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;

/**
 * Created by Roney on 2021/1/4 17:18.
 */
public class CustomDefaultSubjectFactory extends DefaultWebSubjectFactory {


    private ShiroProperties shiroProperties;

    public CustomDefaultSubjectFactory(ShiroProperties shiroProperties) {
        this.shiroProperties = shiroProperties;
    }

    @Override
    public Subject createSubject(SubjectContext context) {
        // 不创建session.
        context.setSessionCreationEnabled(shiroProperties.isSessionEnabled());
        return super.createSubject(context);
    }
}
