/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.config;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.shiro.filter.ShiroAccessControlFilter;
import com.sinosoftgz.starter.shiro.properties.ShiroProperties;
import com.sinosoftgz.starter.shiro.support.CustomDefaultSubjectFactory;
import com.sinosoftgz.starter.shiro.support.CustomRealm;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
@EnableConfigurationProperties(value={ShiroProperties.class})
@ConditionalOnProperty(prefix="spring.shiro", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CustomShiroConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CustomShiroConfiguration.class);
    private static final String DEFAULT_URL = "/**";
    private static final String ANON = "anon";
    private static final String CUSTOM_AUTHC = "customAuthc";
    private static final String CUSTOM_FILTER_FACTORY_NAME = "shiroFilterFactoryBean";
    private ShiroProperties shiroProperties;

    public CustomShiroConfiguration(ShiroProperties shiroProperties) {
        this.shiroProperties = shiroProperties;
    }

    @Bean
    public CustomRealm userRealm() {
        CustomRealm realm = new CustomRealm();
        realm.setCachingEnabled(false);
        return realm;
    }

    @Bean
    public CustomDefaultSubjectFactory subjectFactory() {
        return new CustomDefaultSubjectFactory(this.shiroProperties);
    }

    @Bean
    public SessionManager sessionManager() {
        DefaultSessionManager sessionManager = new DefaultSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(false);
        return sessionManager;
    }

    @Bean
    public SessionStorageEvaluator sessionStorageEvaluator() {
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        return defaultSessionStorageEvaluator;
    }

    @Bean
    public SecurityManager securityManager(CustomRealm customRealm, SessionStorageEvaluator sessionStorageEvaluator, SubjectFactory subjectFactory, SessionManager sessionManager) {
        DefaultWebSecurityManager defaultSecurityManager = new DefaultWebSecurityManager();
        defaultSecurityManager.setRealm((Realm)customRealm);
        DefaultSubjectDAO defaultSubjectDAO = new DefaultSubjectDAO();
        defaultSubjectDAO.setSessionStorageEvaluator(sessionStorageEvaluator);
        defaultSecurityManager.setSubjectDAO((SubjectDAO)defaultSubjectDAO);
        defaultSecurityManager.setSubjectFactory(subjectFactory);
        defaultSecurityManager.setSessionManager(sessionManager);
        return defaultSecurityManager;
    }

    @Bean
    public ShiroAccessControlFilter shiroAccessControlFilter() {
        ShiroAccessControlFilter shiroAccessControlFilter = new ShiroAccessControlFilter();
        return shiroAccessControlFilter;
    }

    @Bean
    public FilterRegistrationBean registration(ShiroAccessControlFilter shiroAccessControlFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)shiroAccessControlFilter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(name={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager, ShiroAccessControlFilter shiroAccessControlFilter) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, ShiroAccessControlFilter> filters = new LinkedHashMap<String, ShiroAccessControlFilter>();
        filters.put(CUSTOM_AUTHC, shiroAccessControlFilter);
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        List<String> urlExcludes = this.shiroProperties.getUrlExcludes();
        if (!CollectionUtils.isEmpty(urlExcludes)) {
            log.info("Shiro URL Excludes : {}", (Object)JSON.toJSONString(urlExcludes));
            for (String urlExclude : urlExcludes) {
                filterChainDefinitionMap.put(urlExclude, ANON);
            }
        } else {
            log.info("Shiro URL Excludes Is Empty .");
        }
        List<String> urlPatterns = this.shiroProperties.getUrlPatterns();
        if (CollectionUtils.isEmpty(urlPatterns)) {
            log.warn("Shiro urlPatterns is empty,set default /**");
            filterChainDefinitionMap.put(DEFAULT_URL, CUSTOM_AUTHC);
        } else {
            for (String urlPattern : urlPatterns) {
                filterChainDefinitionMap.put(urlPattern, CUSTOM_AUTHC);
            }
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean
    public FilterRegistrationBean delegatingFilterProxy() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        DelegatingFilterProxy proxy = new DelegatingFilterProxy();
        proxy.setTargetFilterLifecycle(true);
        proxy.setTargetBeanName(CUSTOM_FILTER_FACTORY_NAME);
        filterRegistrationBean.setFilter((Filter)proxy);
        return filterRegistrationBean;
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

