/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.filter;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.shiro.biz.ShiroUserBiz;
import com.sinosoftgz.starter.shiro.properties.ShiroProperties;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ShiroAccessControlFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(ShiroAccessControlFilter.class);
    @Autowired
    ShiroProperties shiroProperties;
    @Autowired
    ShiroUserBiz shiroUserBiz;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        String token = req.getHeader(this.shiroProperties.getTokenName());
        if (StringUtils.isEmpty((Object)token)) {
            token = request.getParameter(this.shiroProperties.getTokenName());
        }
        final String finalToken = token;
        AuthenticationToken authenticationToken = new AuthenticationToken(){

            public Object getPrincipal() {
                return finalToken;
            }

            public Object getCredentials() {
                return finalToken;
            }
        };
        try {
            this.getSubject(request, response).login(authenticationToken);
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a", (Throwable)e);
            this.returnLoginError(response);
            return false;
        }
        return true;
    }

    public void returnLoginError(ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString((Object)this.shiroUserBiz.onAuthenticationFailed()));
    }
}

