/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.shiro.support;

import com.sinosoftgz.starter.shiro.biz.ShiroUserBiz;
import com.sinosoftgz.starter.shiro.model.ShiroUserInfo;
import java.util.List;
import java.util.Objects;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CustomRealm
extends AuthorizingRealm {
    private static final Logger logger = LoggerFactory.getLogger(CustomRealm.class);
    @Autowired
    ShiroUserBiz shiroUserBiz;

    public boolean supports(AuthenticationToken token) {
        return true;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        List<String> roles;
        logger.info("##################\u6267\u884cShiro\u6743\u9650\u8ba4\u8bc1##################");
        ShiroUserInfo account = (ShiroUserInfo)principalCollection.getPrimaryPrincipal();
        if (StringUtils.isEmpty((Object)account)) {
            throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u6388\u6743\u4fe1\u606f\u5931\u8d25");
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        List<String> permissions = account.getPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            info.addStringPermissions(permissions);
        }
        if ((roles = account.getRoles()) != null) {
            info.addRoles(roles);
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        logger.info("##################\u6267\u884cShiro\u767b\u9646\u8ba4\u8bc1##################");
        String token = (String)authenticationToken.getPrincipal();
        if (StringUtils.isEmpty((Object)token)) {
            throw new AuthenticationException("token\u65e0\u6548");
        }
        ShiroUserInfo sessionUser = this.shiroUserBiz.getUserInfo(token);
        if (Objects.isNull(sessionUser)) {
            throw new AuthenticationException("token\u65e0\u6548");
        }
        return new SimpleAuthenticationInfo((Object)sessionUser, authenticationToken.getCredentials(), this.getName());
    }
}

