/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import com.sinosoftgz.simpleSession.HttpSessionWrapper;
import com.sinosoftgz.simpleSession.data.SessionCacheManager;
import com.sinosoftgz.simpleSession.data.SessionMap;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SessionHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final String CURRENT_SESSION_ATTR = SessionHttpServletRequestWrapper.class.getName();
    private ServletContext servletContext;
    private int maxActiveTime;

    public SessionHttpServletRequestWrapper(HttpServletRequest request, int maxActiveTime, ServletContext servletContext) {
        super(request);
        this.servletContext = servletContext;
        this.maxActiveTime = maxActiveTime;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        SessionMap sessionMap;
        HttpSessionWrapper currentSession = this.getCurrentSession();
        if (currentSession != null) {
            return currentSession;
        }
        String sessionId = null;
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JSESSIONID".equals(cookie.getName().toUpperCase())) continue;
                sessionId = cookie.getValue();
            }
        }
        if (sessionId != null && (sessionMap = SessionCacheManager.getSessionCache().get(sessionId)) != null && !sessionMap.isInvalidated()) {
            currentSession = new HttpSessionWrapper(sessionMap, SessionCacheManager.getSessionCache(), this.maxActiveTime, this.servletContext);
            currentSession.setNew(false);
            this.setCurrentSession(currentSession);
            return currentSession;
        }
        if (!create) {
            return null;
        }
        HttpSession httpSession = super.getSession();
        SessionMap sessionMap2 = new SessionMap(httpSession);
        currentSession = new HttpSessionWrapper(sessionMap2, SessionCacheManager.getSessionCache(), this.maxActiveTime, this.servletContext);
        SessionCacheManager.getSessionCache().put(sessionMap2.getId(), sessionMap2, this.maxActiveTime);
        this.setCurrentSession(currentSession);
        return currentSession;
    }

    private HttpSessionWrapper getCurrentSession() {
        return (HttpSessionWrapper)this.getAttribute(CURRENT_SESSION_ATTR);
    }

    private void setCurrentSession(HttpSessionWrapper currentSession) {
        if (currentSession == null) {
            this.removeAttribute(CURRENT_SESSION_ATTR);
        } else {
            this.setAttribute(CURRENT_SESSION_ATTR, currentSession);
        }
    }

    public boolean isRequestedSessionIdValid() {
        HttpSessionWrapper httpSessionWrapper = (HttpSessionWrapper)this.getSession(false);
        if (httpSessionWrapper == null) {
            return true;
        }
        return httpSessionWrapper.isInvalidated();
    }
}

