/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import com.sinosoftgz.simpleSession.HttpSessionWrapper;
import com.sinosoftgz.simpleSession.data.SessionCache;
import com.sinosoftgz.simpleSession.data.SessionCacheManager;
import com.sinosoftgz.simpleSession.data.SessionMap;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public Logger logger = LoggerFactory.getLogger(SessionHttpServletRequestWrapper.class);
    public static final String CURRENT_SESSION_ATTR = SessionHttpServletRequestWrapper.class.getName();
    private ServletContext servletContext;
    private int cookiesMaxAge;
    private String cookiesDomain;
    private int sessionMaxAge;
    private String JsessionId;
    private HttpServletResponse response;

    public SessionHttpServletRequestWrapper(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, int cookiesMaxAge, String cookiesDomain, int sessionMaxAge, String jsessionId) {
        super(request);
        this.servletContext = servletContext;
        this.cookiesMaxAge = cookiesMaxAge;
        this.cookiesDomain = cookiesDomain;
        this.sessionMaxAge = sessionMaxAge;
        this.JsessionId = jsessionId;
        this.response = response;
    }

    public SessionHttpServletRequestWrapper(HttpServletRequest request, HttpServletResponse response, int cookiesMaxAge, ServletContext servletContext, String JsessionId) {
        super(request);
        this.servletContext = servletContext;
        this.cookiesMaxAge = cookiesMaxAge;
        this.JsessionId = JsessionId;
        this.response = response;
    }

    public SessionHttpServletRequestWrapper(HttpServletRequest request, int cookiesMaxAge, ServletContext servletContext) {
        super(request);
        this.servletContext = servletContext;
        this.cookiesMaxAge = cookiesMaxAge;
    }

    public SessionHttpServletRequestWrapper(HttpServletRequest request, int cookiesMaxAge, ServletContext servletContext, String JsessionId) {
        super(request);
        this.servletContext = servletContext;
        this.cookiesMaxAge = cookiesMaxAge;
        this.JsessionId = JsessionId;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        SessionMap sessionMap;
        HttpSessionWrapper currentSession = this.getCurrentSession();
        SessionCache sessionCache = SessionCacheManager.getSessionCache();
        if (currentSession != null) {
            return currentSession;
        }
        String cookieSessionId = this.getCookieSessionID();
        if (cookieSessionId != null && (sessionMap = sessionCache.get(cookieSessionId)) != null && !sessionMap.isInvalidated()) {
            currentSession = new HttpSessionWrapper(sessionMap, sessionCache, this.sessionMaxAge, this.servletContext);
            currentSession.setNew(false);
            this.setCurrentSession(currentSession);
            return currentSession;
        }
        if (!create) {
            return null;
        }
        sessionMap = new SessionMap((HttpServletRequest)this);
        currentSession = new HttpSessionWrapper(sessionMap, sessionCache, this.sessionMaxAge, this.servletContext);
        if (sessionCache.put(sessionMap.getId(), sessionMap, this.sessionMaxAge)) {
            this.logger.debug(" save session to cache,sessionId is {}", (Object)sessionMap.getId());
        }
        this.setCurrentSession(currentSession);
        this.setCookies(currentSession.getId());
        return currentSession;
    }

    private void refreshSessionCache(String sessionId, SessionCache sessionCache) {
        if (null != sessionId && null != sessionCache) {
            sessionCache.setMaxInactiveInterval(sessionId, this.sessionMaxAge);
        }
    }

    private void setCookies(String cookiesSessionId) {
        Cookie cookie = new Cookie(this.JsessionId, cookiesSessionId);
        cookie.setMaxAge(this.cookiesMaxAge);
        cookie.setDomain(this.cookiesDomain);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        this.response.addCookie(cookie);
    }

    private String getCookieSessionID() {
        String cookieSessionId = null;
        Cookie[] cookies = this.getCookies();
        if (cookies != null && this.JsessionId != null) {
            for (Cookie cookie : cookies) {
                if (!this.JsessionId.equals(cookie.getName())) continue;
                cookieSessionId = cookie.getValue();
                this.logger.debug("get JsessionId from cookies,JsessionId is :{} ", (Object)cookieSessionId);
                break;
            }
        }
        return cookieSessionId;
    }

    private HttpSessionWrapper getCurrentSession() {
        return (HttpSessionWrapper)this.getAttribute(CURRENT_SESSION_ATTR);
    }

    private void setCurrentSession(HttpSessionWrapper currentSession) {
        if (currentSession == null) {
            this.removeAttribute(CURRENT_SESSION_ATTR);
        } else {
            this.setAttribute(CURRENT_SESSION_ATTR, currentSession);
        }
    }

    public boolean isRequestedSessionIdValid() {
        HttpSessionWrapper httpSessionWrapper = (HttpSessionWrapper)this.getSession(false);
        if (httpSessionWrapper == null) {
            return true;
        }
        return httpSessionWrapper.isInvalidated();
    }
}

