/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession.data.redis;

import com.sinosoftgz.simpleSession.data.SerializeUtil;
import com.sinosoftgz.simpleSession.data.SessionCache;
import com.sinosoftgz.simpleSession.data.SessionMap;
import com.sinosoftgz.simpleSession.data.redis.RedisSentinelPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisSessionCache
implements SessionCache {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSessionCache.class);
    private RedisSentinelPool cachePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String sessionId, SessionMap sessionMap, int timeout) {
        boolean flag = false;
        Jedis jedis = null;
        jedis = this.cachePool.getResource();
        if (jedis == null) {
            return false;
        }
        try {
            jedis.set(sessionId.getBytes(), SerializeUtil.serialize(sessionMap));
            jedis.expire(sessionId, timeout);
            flag = true;
        }
        catch (Exception e) {
            LOG.error("Put session to redis error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            jedis.close();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionMap get(String sessionId) {
        Jedis jedis = null;
        SessionMap sessionMap = null;
        byte[] reslut = null;
        jedis = this.cachePool.getResource();
        if (jedis == null) {
            return null;
        }
        try {
            if (jedis.exists(sessionId).booleanValue()) {
                reslut = jedis.get(sessionId.getBytes());
                sessionMap = (SessionMap)SerializeUtil.unserialize(reslut);
            }
        }
        catch (Exception e) {
            LOG.error("Read session from redis error", (Throwable)e);
            SessionMap sessionMap2 = null;
            return sessionMap2;
        }
        finally {
            jedis.close();
        }
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxInactiveInterval(String sessionId, int interval) {
        Jedis jedis = null;
        jedis = this.cachePool.getResource();
        if (null == jedis) {
            LOG.error("jedis is null...");
            return;
        }
        try {
            if (jedis.exists(sessionId).booleanValue()) {
                jedis.expire(sessionId, interval);
            }
        }
        catch (Exception e) {
            LOG.error("Set session max inactive interval to redis error", (Throwable)e);
        }
        finally {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(String sessionId) {
        Jedis jedis = null;
        jedis = this.cachePool.getResource();
        if (null == jedis) {
            LOG.error("jedis is null...");
            return;
        }
        try {
            if (jedis.exists(sessionId).booleanValue()) {
                jedis.expire(sessionId, 0);
            }
        }
        catch (Exception e) {
            LOG.error("Destroy session from redis error", (Throwable)e);
        }
        finally {
            jedis.close();
        }
    }

    public void setCachePool(RedisSentinelPool cachePool) {
        this.cachePool = cachePool;
    }

    @Override
    public boolean isJedisActive() {
        Jedis jedis = this.cachePool.getResource();
        if (null == jedis) {
            LOG.error("jedis is null...");
            return false;
        }
        jedis.close();
        return true;
    }
}

