package com.sinosoftgz.simpleSession.user;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 用户自定义filter 
 * @author dragon
 * 日期  2016年5月27日
 */
public class UserSessionFilter implements Filter{

	private Logger logger = LoggerFactory.getLogger(UserSessionFilter.class);
	
	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		// TODO Auto-generated method stub
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,FilterChain chain) throws IOException, ServletException {

		HttpServletRequest  httpServletRequest  = (HttpServletRequest)request;
		
		Object userInfoObj = httpServletRequest.getSession().getAttribute(CurrentUser.SESSION_USERINFO);
		
		if (userInfoObj != null) {
			logger.debug("获取用户信息保存到本地");	
			CurrentUser.setUser(userInfoObj);
		}
		logger.debug("用户信息:{}",userInfoObj);
		
		chain.doFilter(request, response);
		
		if (CurrentUser.getUser() != null) {
			logger.debug("删除本地用户信息");
			CurrentUser.removeUser();
		}
		logger.debug("用户信息:{}",CurrentUser.getUser());
		
	}
	

	@Override
	public void destroy() {
		// TODO Auto-generated method stub
	}

}
