package com.sinosoftgz.simpleSession.user;

/**
 * <p>当前用户
 * <p>@author dragon
 * <p>@date 2016年5月27日
 * <p>@version 1.0
 */
public class CurrentUser {

	public final static String SESSION_USERINFO = "SESSION_USERINFO";
	
	/**
	 * 用户线程绑定
	 */
	private static ThreadLocal<Object> userLocal = new ThreadLocal<Object>();

	public static void setUser(Object userInfo) {
		userLocal.set(userInfo);
	}

	public static Object getUser() {
		return userLocal.get();
	}
	
	public static void removeUser(){
		userLocal.remove();
	}
	
}
