/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import com.sinosoftgz.simpleSession.SessionHttpServletRequestWrapper;
import com.sinosoftgz.simpleSession.data.SessionCache;
import com.sinosoftgz.simpleSession.data.SessionCacheManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSharingFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(SessionSharingFilter.class);
    private ServletContext servletContext;
    private int cookiesMaxAge;
    private String cookiesDomain;
    private String jsessionId;
    private int sessionMaxAge;
    private String prefix;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        String cookiesMaxAgeStr = filterConfig.getInitParameter("cookiesMaxAge");
        this.cookiesMaxAge = StringUtils.isNotEmpty((CharSequence)cookiesMaxAgeStr) ? Integer.parseInt(cookiesMaxAgeStr) : 0;
        this.cookiesDomain = filterConfig.getInitParameter("cookiesDomain");
        if (StringUtils.isEmpty((CharSequence)this.cookiesDomain)) {
            this.cookiesDomain = "/";
        }
        this.jsessionId = filterConfig.getInitParameter("jsessionId");
        if (StringUtils.isEmpty((CharSequence)this.jsessionId)) {
            this.jsessionId = "jsid";
        }
        String sessionMaxAgeStr = filterConfig.getInitParameter("sessionMaxAge");
        this.sessionMaxAge = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{sessionMaxAgeStr}) ? Integer.parseInt(sessionMaxAgeStr) : 0;
        this.prefix = filterConfig.getInitParameter("prefix");
        if (StringUtils.isEmpty((CharSequence)this.prefix)) {
            this.prefix = "B2C";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        SessionCache sessionCache = SessionCacheManager.getSessionCache();
        if (sessionCache != null && sessionCache.isJedisActive()) {
            this.logger.debug("using cache's session");
            SessionHttpServletRequestWrapper sessionHttpServletRequestWrapper = new SessionHttpServletRequestWrapper(httpServletRequest, httpServletResponse, this.servletContext, this.cookiesMaxAge, this.cookiesDomain, this.sessionMaxAge, this.jsessionId, this.prefix);
            this.refreshSessionCache(sessionHttpServletRequestWrapper.getSession().getId(), sessionCache);
            try {
                chain.doFilter((ServletRequest)sessionHttpServletRequestWrapper, (ServletResponse)httpServletResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (sessionHttpServletRequestWrapper.isRequestedSessionIdValid()) {
                    Cookie cookie = new Cookie(this.jsessionId, null);
                    cookie.setMaxAge(0);
                    cookie.setPath("/");
                    cookie.setDomain(this.cookiesDomain);
                    cookie.setHttpOnly(true);
                    httpServletResponse.addCookie(cookie);
                    HttpSession httpSession = sessionHttpServletRequestWrapper.getSession(false);
                    if (httpSession != null) {
                        SessionCacheManager.getSessionCache().put(httpSession.getId(), null, 0);
                    }
                }
            }
            return;
        }
        this.logger.debug("using container's session");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void refreshSessionCache(String sessionId, SessionCache sessionCache) {
        if (null != sessionId && null != sessionCache) {
            sessionCache.setMaxInactiveInterval(sessionId, this.sessionMaxAge);
        }
    }

    public int getCookiesMaxAge() {
        return this.cookiesMaxAge;
    }

    public void setCookiesMaxAge(int cookiesMaxAge) {
        this.cookiesMaxAge = cookiesMaxAge;
    }

    public String getCookiesDomain() {
        return this.cookiesDomain;
    }

    public void setCookiesDomain(String cookiesDomain) {
        this.cookiesDomain = cookiesDomain;
    }

    public String getJsessionId() {
        return this.jsessionId;
    }

    public void setJsessionId(String jsessionId) {
        this.jsessionId = jsessionId;
    }

    public int getSessionMaxAge() {
        return this.sessionMaxAge;
    }

    public void setSessionMaxAge(int sessionMaxAge) {
        this.sessionMaxAge = sessionMaxAge;
    }
}

