/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession.data.redis;

import com.sinosoftgz.simpleSession.data.SerializeUtil;
import com.sinosoftgz.simpleSession.data.SessionCache;
import com.sinosoftgz.simpleSession.data.SessionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class RedisSessionCache
implements SessionCache {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSessionCache.class);
    private JedisCluster JedisCluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String sessionId, SessionMap sessionMap, int timeout) {
        boolean flag = false;
        Object jedis = null;
        if (jedis == null) {
            return false;
        }
        try {
            this.JedisCluster.set(sessionId, SerializeUtil.serializeToString(sessionMap));
            jedis.expire(sessionId, timeout);
            flag = true;
        }
        catch (Exception e) {
            LOG.error("Put session to redis error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            jedis.close();
        }
        return flag;
    }

    @Override
    public SessionMap get(String sessionId) {
        SessionMap sessionMap = null;
        String reslut = null;
        try {
            if (this.JedisCluster.exists(sessionId).booleanValue()) {
                reslut = this.JedisCluster.get(sessionId);
                sessionMap = (SessionMap)SerializeUtil.unserializeFromString(reslut);
            }
        }
        catch (Exception e) {
            LOG.error("Read session from redis error", (Throwable)e);
            return null;
        }
        return sessionMap;
    }

    @Override
    public void setMaxInactiveInterval(String sessionId, int interval) {
        try {
            if (this.JedisCluster.exists(sessionId).booleanValue()) {
                this.JedisCluster.expire(sessionId, interval);
            }
        }
        catch (Exception e) {
            LOG.error("Set session max inactive interval to redis error", (Throwable)e);
        }
    }

    @Override
    public void destroy(String sessionId) {
        try {
            if (this.JedisCluster.exists(sessionId).booleanValue()) {
                this.JedisCluster.expire(sessionId, 0);
            }
        }
        catch (Exception e) {
            LOG.error("Destroy session from redis error", (Throwable)e);
        }
    }

    @Override
    public boolean isJedisActive() {
        return true;
    }

    public JedisCluster getJedisCluster() {
        return this.JedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.JedisCluster = jedisCluster;
    }
}

