package sinosoftgz.utils.data;

import java.util.Collection;

/**
 * @author Liang Wenxu
 * @since 2018/12/20
 */
public interface TreeNode<T> {
    /**
     * 获取当前节点id
     * @return
     */
    String getId();
    /**
     * 设置当前节点id
     * @return
     */
    void setId(String id);

    /**
     * 获取父级id
     * @return
     */
    String getPid();

    /**
     * 设置父级id
     * @return
     */
    void setPid(String id);

    /**
     * 获取所有子节点
     * @return
     */
    Collection<TreeNode> getChildren();

    /**
     * 设置所有子节点
     * @param children
     */
    void setChildren(Collection<TreeNode> children);

    /**
     * 获取节点值
     * @return
     */
    T getValue();

    /**
     * 设置节点值
     * @param value
     */
    void setValue(T value);
}
