package sinosoftgz.utils.data;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Collection;

/**
 * 树形节点，通过继承扩展
 * @author Liang Wenxu
 * @since 2018/12/20
 */
@Data
@EqualsAndHashCode
public abstract class AbstractTreeNode implements TreeNode {
    private String id;

    private String pid;

    private Collection<AbstractTreeNode> children;

    /**
     * 设置所有子节点
     *
     * @param children
     */
    @Override
    public void setChildren(Collection children) {
        this.children = children;
    }
}
