package sinosoftgz.utils.io;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Date;

/**
 * 文件实体类
 *
 * @Project Augurit
 * @Author LiRuiFa
 * @ClassName FileEntity
 * @Date 2019/6/13 15:28
 * @Version 1.0
 **/
public class FileEntity {

    //文件主键ID
    private String id;
    
    //文件名称
    private String name;

    //文件新名称
    private String newName;

    //文件链接
    private String link;

    //文件路径
    private String path;

    //文件大小
    private String size;

    //文件后缀
    private String extension;

    //文件创建时间
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date uploadTime;

    public FileEntity() {
    }

    public FileEntity(String id,String name, String newName, String extension, String link, String path, String size, Date uploadTime) {
        this.id = id;
        this.name = name;
        this.newName = newName;
        this.extension = extension;
        this.link = link;
        this.path = path;
        this.size = size;
        this.uploadTime = uploadTime;
    }

    public FileEntity(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.newName = builder.newName;
        this.extension = builder.extension;
        this.link = builder.link;
        this.path = builder.path;
        this.size = builder.size;
        this.uploadTime = builder.uploadTime;
    }

    public static class Builder {

        private String id;
        private String name;
        private String newName;
        private String extension;
        private String link;
        private String path;
        private String size;
        private Date uploadTime;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setNewName(String newName) {
            this.newName = newName;
            return this;
        }

        public Builder setExtension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder setLink(String link) {
            this.link = link;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setSize(String size) {
            this.size = size;
            return this;
        }

        public Builder setUploadTime(Date uploadTime) {
            this.uploadTime = uploadTime;
            return this;
        }

        public FileEntity build() {
            return new FileEntity(this);
        }

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNewName() {
        return newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Date getUploadTime() {
        return uploadTime;
    }

    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }
}
