/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DerivedExcelXlsx {
    public static final String CELL_STYLE_NEED_INPUT = "input";
    String fileName;
    Collection collection;
    HttpServletResponse response;
    Map map;
    Map colStyleMap;
    Class dtoClass;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int PERSHEET = 50000;

    public void setColStyleMap(Map colStyleMap) {
        this.colStyleMap = colStyleMap;
    }

    public DerivedExcelXlsx() {
    }

    public DerivedExcelXlsx(String fileName, Collection collection, HttpServletResponse response, Map map, Class dtoClass) {
        this.fileName = fileName;
        this.collection = collection;
        this.response = response;
        this.map = map;
        this.dtoClass = dtoClass;
    }

    public void doDerivedExcel() throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.setRows(workbook);
        this.inTOStream(workbook, this.response);
    }

    private void setRows(XSSFWorkbook workbook) throws Exception {
        XSSFSheet sheet = null;
        XSSFCell cell = null;
        int sheetCount = 0;
        XSSFRow row = null;
        XSSFCellStyle cellStyle = this.setCellStyle(workbook);
        Map getDtoMap = DerivedExcelXlsx.getAllSetter(this.dtoClass);
        Object object = this.dtoClass.newInstance();
        Class<?> clazz = object.getClass();
        int t = 0;
        Iterator dataIterator = this.collection.iterator();
        Set keySet = this.map.keySet();
        Class<?> returnType = null;
        Object returnValue = null;
        XSSFCellStyle cellStyle2 = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        cellStyle2.setDataFormat(format.getFormat("@"));
        XSSFCellStyle cellStyleDateTime = workbook.createCellStyle();
        XSSFDataFormat formatDateTime = workbook.createDataFormat();
        cellStyleDateTime.setDataFormat(formatDateTime.getFormat("yyyy-MM-dd HH:mm:ss"));
        XSSFCellStyle cellStyle3 = workbook.createCellStyle();
        XSSFDataFormat format3 = workbook.createDataFormat();
        cellStyle3.setDataFormat(format3.getFormat("#,##0.00"));
        LinkedHashMap<String, XSSFCellStyle> cellStyles = new LinkedHashMap<String, XSSFCellStyle>();
        XSSFCellStyle cellStyleInput = workbook.createCellStyle();
        cellStyleInput.setDataFormat(format.getFormat("@"));
        cellStyleInput.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        cellStyleInput.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyleInput.setBorderTop(BorderStyle.THIN);
        cellStyleInput.setBorderLeft(BorderStyle.THIN);
        cellStyleInput.setBorderBottom(BorderStyle.THIN);
        cellStyleInput.setBorderRight(BorderStyle.THIN);
        cellStyles.put(CELL_STYLE_NEED_INPUT, cellStyleInput);
        String cellStyleIdx = "";
        while (dataIterator.hasNext()) {
            int i = 0;
            sheetCount = t / 50000;
            if (t == 0 || t % 50000 == 0) {
                sheet = workbook.createSheet("data" + (sheetCount + 1));
                row = sheet.createRow(0);
                for (int ii = 0; ii < this.map.size(); ++ii) {
                    sheet.setColumnWidth((int)((short)ii), 4800);
                }
                cell = this.setTitle(cell, cellStyle, row);
            }
            object = dataIterator.next();
            row = sheet.createRow(++t - sheetCount * 50000);
            Iterator i2 = keySet.iterator();
            List allMethods = Arrays.stream(clazz.getMethods()).map(Method::getName).collect(Collectors.toList());
            while (i2.hasNext()) {
                cell = row.createCell((int)((short)i));
                ++i;
                String curKey = i2.next().toString();
                String strKey = "get" + curKey;
                String methodKey = "" + getDtoMap.get(strKey.toLowerCase());
                if (!StringUtils.isEmpty((CharSequence)methodKey) && allMethods.contains(methodKey)) {
                    Method m2 = clazz.getMethod(methodKey, null);
                    returnType = m2.getReturnType();
                    returnValue = m2.invoke(object, new Object[0]);
                    if (returnValue != null) {
                        if (returnType == Integer.class) {
                            cell.setCellValue((double)((Integer)returnValue).intValue());
                        } else if (returnType == Long.class) {
                            cell.setCellValue(((Long)returnValue).toString());
                        } else if (returnType == Double.class) {
                            cell.setCellValue(((Double)returnValue).doubleValue());
                        } else if (returnType == BigDecimal.class) {
                            cell.setCellValue(((BigDecimal)returnValue).doubleValue());
                        } else if (returnType == String.class) {
                            cell.setCellValue("" + returnValue);
                            cell.setCellStyle((CellStyle)cellStyle2);
                        } else if (returnType == Date.class) {
                            cell.setCellValue("" + returnValue);
                            cell.setCellStyle((CellStyle)cellStyleDateTime);
                        } else if (returnType == LocalDateTime.class) {
                            cell.setCellValue("" + returnValue);
                            cell.setCellStyle((CellStyle)cellStyleDateTime);
                        } else {
                            cell.setCellValue("" + returnValue);
                        }
                    }
                }
                if (this.colStyleMap == null || StringUtils.isEmpty((CharSequence)(cellStyleIdx = (String)this.colStyleMap.get(curKey))) || cellStyles.get(cellStyleIdx) == null) continue;
                cell.setCellStyle((CellStyle)cellStyles.get(cellStyleIdx));
            }
        }
    }

    private XSSFCell setTitle(XSSFCell cell, XSSFCellStyle cellStyle, XSSFRow row) {
        Set s1 = this.map.keySet();
        Collection c1 = this.map.values();
        Iterator it = c1.iterator();
        int itInt = 0;
        while (it.hasNext()) {
            cell = row.createCell((int)((short)itInt));
            ++itInt;
            cell.setCellValue("" + it.next());
            cell.setCellStyle((CellStyle)cellStyle);
        }
        return cell;
    }

    private void inTOStream(XSSFWorkbook workbook, HttpServletResponse response) throws Exception {
        File downFile = new File(this.fileName + ".xlsx");
        response.setHeader("Content-Disposition", "attachment; filename=" + new String(downFile.getName().getBytes("gb2312"), "iso8859-1"));
        ServletOutputStream sos = response.getOutputStream();
        workbook.write((OutputStream)sos);
        sos.flush();
    }

    private static Map getAllSetter(Class cl) {
        HashMap<String, String> methodMap = new HashMap<String, String>();
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get")) continue;
            methodMap.put(methodName.toLowerCase(), methodName);
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            methodMap.putAll(DerivedExcelXlsx.getAllSetter(cl));
        }
        return methodMap;
    }

    private XSSFCellStyle setCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setDtoClass(Class dtoClass) {
        this.dtoClass = dtoClass;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }
}

