package sinosoftgz.utils.encrypt.impl;

import sinosoftgz.utils.data.StandardCharset;
import sinosoftgz.utils.encrypt.EncryptHandler;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * 抽象加密处理器
 * @author Liang Wenxu
 * @since 2018/12/18
 */
public abstract class AbstratEncryptHandler implements EncryptHandler {
    /**
     * 获取加密算法对象，子类必须实现
     * @return
     */
    protected abstract MessageDigest messageDigest() throws NoSuchAlgorithmException;

    /**
     * 执行加密
     * @param src 原字符串
     * @param salt 加密盐
     * @param charset 字符集
     * @return 返回加密后的字符串
     * @throws UnsupportedEncodingException
     * @throws NoSuchAlgorithmException
     */
    @Override
    public String encrypt(String src, String salt, StandardCharset charset) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if(src == null) {
            return null;
        }
        MessageDigest msgDigest = messageDigest();

        byte[] saltBytes = salt.getBytes(charset.value());
        byte[] byteArray = src.getBytes(charset.value());
        msgDigest.update(saltBytes);
        byte[] digestedBytes = msgDigest.digest(byteArray);
        return toHexString(digestedBytes);
    }

    /**
     * 字符数组转换Hex字符串
     * @param bytes 字符数组
     * @return 返回Hex字符串
     */
    protected String toHexString(byte[] bytes) {
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            int val = ((int) bytes[i]) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
}
