package sinosoftgz.utils.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

/**
 * @author zhanghongwei
 * @since 2019/2/22
 * 模板工具
 */
public class TemplateUtils {

    /**
     * 渲染文本模板
     * @param templateString 模板内容
     * @param data 渲染数据
     * @return
     */
    public static String renderString(String templateString, Map<String, Object> data)
            throws Exception {
        Properties settings = new Properties();
        settings.setProperty("template_update_delay", "120");
        settings.setProperty("locale", "zh_CN");
        settings.setProperty("datetime_format", "yyyy-MM-dd'T'HH:mm");
        settings.setProperty("date_format", "yyyy-MM-dd");
        settings.setProperty("number_format", "#.##");

        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setSettings(settings);
        cfg.setClassForTemplateLoading(TemplateUtils.class,"/");
        //加载装载的模板
        Template temp = new Template("default", new StringReader(templateString), cfg);

        Writer out = new StringWriter();
        temp.process(data, out);
        return out.toString().replaceAll("\r","").replaceAll("\n","")
                .replaceAll("\t","").replaceAll("  ","");
    }
}
