/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import sinosoftgz.utils.data.AbstractTreeNode;
import sinosoftgz.utils.data.TreeNode;
import sinosoftgz.utils.lang.Lang;

public class TreeUtils {
    public static <T extends TreeNode> List<T> list2Tree(List<T> list, Class<T> tClass) {
        LinkedList<TreeNode> tree = new LinkedList<TreeNode>();
        LinkedList<TreeNode> visitedNodes = new LinkedList<TreeNode>();
        List unvisitedNodes = list.stream().filter(i -> Lang.isEmpty(i.getPid())).collect(Collectors.toList());
        HashMap<String, TreeNode> lastParents = new HashMap<String, TreeNode>(list.size());
        while (!unvisitedNodes.isEmpty()) {
            for (TreeNode tn : unvisitedNodes) {
                if (tn.getChildren() == null) {
                    tn.setChildren(new ArrayList<TreeNode>());
                }
                if (Lang.isEmpty(tn.getPid()) || "0".equals(tn.getPid())) {
                    tree.add(tn);
                } else {
                    TreeNode parent = (TreeNode)lastParents.get(tn.getPid());
                    if (parent != null) {
                        parent.getChildren().add(tn);
                    } else {
                        tree.add(tn);
                    }
                }
                lastParents.put(tn.getId(), tn);
                visitedNodes.add(tn);
            }
            List pids = unvisitedNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
            List visitedIds = visitedNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
            unvisitedNodes = list.stream().filter(n -> pids.contains(n.getPid()) && !visitedIds.contains(n.getId())).collect(Collectors.toList());
        }
        return tree;
    }

    private static List<AbstractTreeNode> tree2listDeepth(String id, List<AbstractTreeNode> tree) {
        LinkedList<AbstractTreeNode> visitedNodes = new LinkedList<AbstractTreeNode>();
        List<AbstractTreeNode> unvisitedNodes = tree;
        while (!unvisitedNodes.isEmpty()) {
            AbstractTreeNode currNode = unvisitedNodes.remove(0);
            List newNodes = currNode.getChildren().stream().filter(node -> !visitedNodes.contains(node)).collect(Collectors.toList());
            unvisitedNodes.addAll(0, newNodes);
            visitedNodes.add(currNode);
        }
        return visitedNodes;
    }

    public static List<AbstractTreeNode> tree2listBreadth(List<AbstractTreeNode> tree) {
        LinkedList<AbstractTreeNode> visitedNodes = new LinkedList<AbstractTreeNode>();
        List<Object> unvisitedNodes = new ArrayList();
        Collections.copy(tree, unvisitedNodes);
        while (!unvisitedNodes.isEmpty()) {
            List newNodes = unvisitedNodes.stream().map(i -> i.getChildren()).flatMap(Collection::stream).filter(node -> !visitedNodes.contains(node)).collect(Collectors.toList());
            visitedNodes.addAll(unvisitedNodes);
            unvisitedNodes = newNodes;
        }
        return visitedNodes;
    }
}

