/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import sinosoftgz.utils.io.FileEntity;

public class FileUtil {
    public static FileEntity getFileEntity(MultipartFile multipartFile, String path, String link) {
        try {
            if (null == multipartFile) {
                return null;
            }
            double kb = (double)multipartFile.getSize() / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            String name = new String(multipartFile.getOriginalFilename().substring(0, multipartFile.getOriginalFilename().lastIndexOf(".")).getBytes("GBK"), System.getProperty("sun.jnu.encoding"));
            String extension = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(".") + 1, multipartFile.getOriginalFilename().length());
            return new FileEntity.Builder().setId(id).setName(name).setExtension(extension).setSize(gb >= 1.0 ? gb + "GB" : (mb >= 1.0 ? mb + "MB" : kb + "KB")).setPath(FileUtil.getPath(path) + File.separator + "temporary" + File.separator + id + "." + extension).setLink(link + "/temporary/" + id + "." + extension).setUploadTime(new Date()).build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FileEntity getFileEntity(File file, String path, String link) {
        try {
            if (null == file) {
                return null;
            }
            double kb = (double)file.length() / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            String name = new String(file.getName().substring(0, file.getName().lastIndexOf(".")).getBytes("GBK"), System.getProperty("sun.jnu.encoding"));
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
            return new FileEntity.Builder().setId(id).setName(name).setExtension(extension).setSize(gb >= 1.0 ? gb + "GB" : (mb >= 1.0 ? mb + "MB" : kb + "KB")).setPath(FileUtil.getPath(path) + File.separator + "temporary" + File.separator + id + "." + extension).setLink(link + "/temporary/" + id + "." + extension).setUploadTime(new Date()).build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FileEntity getFileEntity(File file) {
        try {
            if (null == file) {
                return null;
            }
            double kb = (double)file.length() / 1024.0;
            double mb = kb / 1024.0;
            double gb = mb / 1024.0;
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            String name = new String(file.getName().substring(0, file.getName().lastIndexOf(".")).getBytes("GBK"), System.getProperty("sun.jnu.encoding"));
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
            return new FileEntity.Builder().setId(id).setName(name).setExtension(extension).setSize(gb >= 1.0 ? gb + "GB" : (mb >= 1.0 ? mb + "MB" : kb + "KB")).setPath(file.getPath()).setLink(null).setUploadTime(new Date()).build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyFileUsingFileChannels(File source, File dest) throws Exception {
        AbstractInterruptibleChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
        }
        catch (Exception e) {
            throw new Exception("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            inputChannel.close();
            outputChannel.close();
        }
    }

    public static String getRandom() {
        Random random = new Random();
        int rannum = (int)(random.nextDouble() * 90000.0) + 10000;
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String nowTimeStr = sDateFormat.format(new Date());
        return nowTimeStr + rannum;
    }

    public static boolean createFolder(String folderPath) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)folderPath)) {
                throw new Exception("folderPath is not null!");
            }
            File dirPath = new File(folderPath);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u6587\u4ef6\u5939\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static boolean createFileFolder(String fileFolder) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)fileFolder)) {
                throw new Exception("fileFolder is not null!");
            }
            int dir = fileFolder.lastIndexOf(File.separator);
            File dirPath = new File(fileFolder.substring(0, dir));
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u6587\u4ef6\u5939\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static boolean deleteFile(String filePath) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)filePath)) {
                throw new Exception("filePath is not null!");
            }
            File myFilePath = new File(filePath);
            if (myFilePath.exists()) {
                return myFilePath.delete();
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("\u5220\u9664\u6587\u4ef6\u5939\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static File createFile(File file) {
        if (file.exists() && file.isFile()) {
            file.delete();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile.exists()) {
            if (parentFile.isFile()) {
                parentFile.delete();
                parentFile.mkdirs();
            }
        } else {
            parentFile.mkdirs();
        }
        try {
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFolder(String folderPath) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)folderPath)) {
                throw new Exception("folderPath is not null!");
            }
            FileUtil.deleteAllFile(folderPath);
            File myFilePath = new File(folderPath);
            myFilePath.delete();
            return !new File(folderPath).exists();
        }
        catch (Exception e) {
            throw new Exception("\u5220\u9664\u6587\u4ef6\u5939\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static boolean checkFileOrFolder(String path) {
        try {
            if (StringUtils.isBlank((CharSequence)path)) {
                return false;
            }
            File file = new File(path = FileUtil.checkPath(path));
            return file.exists() || file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteAllFile(String filePath) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)filePath)) {
                throw new Exception("filePath is not null!");
            }
            boolean flag = false;
            File file = new File(filePath);
            if (!file.exists()) {
                return flag;
            }
            if (!file.isDirectory()) {
                return flag;
            }
            String[] tempList = file.list();
            File temp = null;
            for (int i = 0; i < tempList.length; ++i) {
                temp = filePath.endsWith(File.separator) ? new File(filePath + tempList[i]) : new File(filePath + File.separator + tempList[i]);
                if (temp.isFile()) {
                    temp.delete();
                }
                if (!temp.isDirectory()) continue;
                FileUtil.deleteAllFile(filePath + "/" + tempList[i]);
                FileUtil.deleteFolder(filePath + "/" + tempList[i]);
                flag = true;
            }
            return flag;
        }
        catch (Exception e) {
            throw new Exception("\u5220\u9664\u6587\u4ef6\u5939\u4e0b\u7684\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static String getParent(String filePath) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)filePath)) {
                throw new Exception("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            File file = new File(filePath);
            if (null == file) {
                throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            if (!file.exists()) {
                throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            return file.getParent();
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u6587\u4ef6\u7236\u8282\u70b9\u5931\u8d25: " + e.getMessage());
        }
    }

    public static boolean saveFile(File file, String savePath) throws Exception {
        try {
            FileUtil.createFileFolder(savePath);
            FileUtils.copyFile((File)file, (File)new File(savePath));
            return true;
        }
        catch (Exception e) {
            throw new Exception("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static boolean saveMultipartFile(MultipartFile multipartFile, String savePath) throws Exception {
        InputStream in = null;
        try {
            FileUtil.createFileFolder(savePath);
            in = multipartFile.getInputStream();
            File out = new File(savePath);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)out);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new Exception("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new Exception("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    public static String toBeautifyJson(String jsonStr) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                throw new Exception("jsonStr is not null!");
            }
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(jsonStr, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new Exception("\u683c\u5f0f\u5316json\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static String convertSymbolPath(String path) {
        String symbol = File.separator;
        StringBuilder newPath = new StringBuilder();
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0 && (chars[i] == '/' || chars[i] == '\\')) {
                newPath.append(symbol);
                continue;
            }
            if (i != 0 && (chars[i] == '/' || chars[i] == '\\') && (chars[i - 1] == '/' || chars[i - 1] == '\\')) continue;
            if (!(i == 0 || chars[i] != '/' && chars[i] != '\\' || chars[i - 1] == '/' && chars[i - 1] == '\\')) {
                newPath.append(symbol);
                continue;
            }
            newPath.append(chars[i]);
        }
        return newPath.toString();
    }

    public static String getPath(String path) {
        if ("/".equals(File.separator)) {
            path = path.replaceAll("\\\\", "/");
            path = path.replaceAll("//", "/");
        }
        if ("\\".equals(File.separator)) {
            path = path.replaceAll("//", "\\\\");
            path = path.replaceAll("/", "\\\\");
            path = path.replaceAll("\\\\", "\\\\");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(HttpServletRequest request, HttpServletResponse response, File file) {
        FileEntity fileEntity = FileUtil.getFileEntity(file);
        if (file.exists()) {
            FileUtil.setHeader(request, response, fileEntity.getName());
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                ServletOutputStream os = response.getOutputStream();
                int i = bis.read(buffer);
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
            }
            catch (Exception e) {
                FileUtil.setResponseJson(response, "\u4e0b\u8f7d\u5931\u8d25!");
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            FileUtil.setResponseJson(response, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4e0b\u8f7d\u5931\u8d25!");
            return;
        }
    }

    public static boolean setHeader(HttpServletRequest request, HttpServletResponse response, String fileName) {
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("content-type", "application/octet-stream");
            String browser = request.getHeader("User-Agent");
            if (-1 < browser.indexOf("MSIE 6.0") || -1 < browser.indexOf("MSIE 7.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else if (-1 < browser.indexOf("MSIE 8.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("MSIE 9.0")) {
                response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Chrome")) {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            } else if (-1 < browser.indexOf("Safari")) {
                response.addHeader("content-disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO8859-1"));
            } else {
                response.addHeader("content-disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setResponseJson(HttpServletResponse response, String json) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/json;charset=utf-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println(json);
            if (null == out) return true;
            out.close();
            return true;
        }
        catch (IOException ex) {
            try {
                boolean bl = false;
                if (null == out) return bl;
                out.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (null == out) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
    }

    public static String checkPath(String path) {
        try {
            if (StringUtils.isBlank((CharSequence)path)) {
                return path;
            }
            if ("\\".equals(System.getProperty("file.separator"))) {
                return path.replaceAll("\\\\", System.getProperty("file.separator") + System.getProperty("file.separator"));
            }
            return path.replaceAll("\\\\", System.getProperty("file.separator"));
        }
        catch (Exception e) {
            return path;
        }
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.checkPath("test\\com\\jeecms\\common\\util\\1.bmp"));
    }
}

