package sinosoftgz.utils.http.okhttp;

import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import sinosoftgz.utils.http.HttpClientService;
import sinosoftgz.utils.http.entity.HttpRequest;

import java.io.IOException;

/**
 * @author Liang Wenxu
 * @since 2019/5/14
 */
public class OkHttpClientService implements HttpClientService {
    ThreadLocal<OkHttpClient> okHttpClientThreadLocal;

    protected OkHttpClient getOkHttpClient() {
        if (okHttpClientThreadLocal == null) {
            okHttpClientThreadLocal = new ThreadLocal<>();
            okHttpClientThreadLocal.set(null);
        }
        OkHttpClient okHttpClient = okHttpClientThreadLocal.get();
        if(okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            okHttpClient = builder.build();
            okHttpClientThreadLocal.set(okHttpClient);

        }
        return okHttpClient;
    }

    @Override
    public byte[] doGet(HttpRequest httpRequest) throws IOException {
        Request request = new Request.Builder()
                .url(httpRequest.getUrl())
                .get()
                .build();
        Call call = getOkHttpClient().newCall(request);
        Response response = call.execute();
        return response.body().bytes();
    }

    @Override
    public byte[] doPost(HttpRequest httpRequest) {
        return null;
    }

    @Override
    public byte[] doDelete(HttpRequest httpRequest) {
        return null;
    }

    @Override
    public byte[] doPut(HttpRequest httpRequest) {
        return null;
    }
}
