
package sinosoftgz.utils.string;

import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.*;

/**
 * 
 * <p>
 * Description : 字符串共通工具类
 * </p>
 * Created by Roney on 2016/5/3.
 * 
 * @version
 */
public class TextUtils {
	/**
	 * 左起标识
	 */
	public static int LEFT = 1;

	/**
	 * 右标识
	 */
	public static int RIGHT = 2;

	/**
	 * 判断字符串是否为空
	 * 
	 * @param str
	 *            字符串
	 * @return boolean
	 */
	public static boolean isNullOrEmpty(String str) {
		if (str == null || "".equals(str)) {
			return true;
		}

		return false;
	}

	/**
	 * 格式化字符串，如果str为null,返回（""）空
	 * 
	 * @param str
	 *            字符串
	 * @return string
	 */
	public static String nullToEmpty(String str) {
		if (str == null) {
			return "";
		}
		return str.toString();
	}

	/**
	 * 判断数组内是否存在指定字符串(完全相等)
	 * 
	 * @param str
	 *            字符串
	 * @param strArray
	 *            数组
	 * @return boolean
	 */
	public static boolean isInArray(String str, String[] strArray) {
		boolean result = false;

		for (int i = 0, length = strArray.length; i < length; i++) {
			if (strArray[i].equals(str)) {
				result = true;
				break;
			}
		}

		return result;
	}

	/**
	 * 获取指定长度的随机数字符串
	 * 
	 * @param length
	 *            长度
	 * @return 返回随机字符串
	 */
	public static String getDesignedLengthRandom(int length) {
		return String.valueOf(Math.random()).substring(2, length + 2);
	}

	/**
	 * 判断Map对象元素有无空值，有就返回true
	 * 
	 * @param map
	 *            map对象
	 * @return boolean
	 */
	public static boolean isMapParamNull(Map<String, Object> map) {
		boolean isMapParamNull = false;
		Iterator it = map.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry e = (Map.Entry) it.next();

			if (e.getValue() == null || e.getValue().equals("")) {
				isMapParamNull = true;
			}
		}

		return isMapParamNull;
	}

	/**
	 * 填充字符
	 * 
	 * @param str
	 *            字符串
	 * @param totalLenth
	 *            长度
	 * @param leftOrRight
	 *            左右
	 * @param padingChar
	 *            填充字符
	 * @return
	 */
	public static String Pading(String str, int totalLenth, int leftOrRight,
			char padingChar) {

		String rtn = null;

		if (str.length() >= totalLenth) {
			return str;
		}

		int count = totalLenth - str.length();
		char[] padingChars = new char[count];
		for (int i = 0; i < count; i++) {
			padingChars[i] = padingChar;
		}

		if (leftOrRight == LEFT) {
			rtn = String.valueOf(padingChars) + str;
		} else if (leftOrRight == RIGHT) {
			rtn = str + padingChars.toString();
		} else {
			return str;
		}

		return rtn;
	}

	/**
	 * 产生随机6位验证码
	 * 
	 * @return
	 */
	public static String getSecurityCode() {
		Random rd = new Random();
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < 6; i++) {
			int _num = rd.nextInt(10);
			sb.append(_num);
		}
		return sb.toString();
	}

	public static boolean isNotBlank(String gotoUrl) {
		if (gotoUrl != null && gotoUrl.isEmpty() == false
				&& gotoUrl.trim().isEmpty() == false)
			return true;
		return false;
	}

	public static boolean isEmpty(String str) {
		if (str != null && str.isEmpty() == false
				&& str.trim().isEmpty() == false)
			return false;
		return true;
	}

	public static String newString(String iString, int iTimes) {
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < iTimes; ++i)
			buffer.append(iString);

		return buffer.toString();
	}

	public static String space(int iLength) {
		return newString(" ", iLength);
	}

	public static int getLength(String iString) {
		return iString.getBytes().length;
	}

	public static String unicodeToGBK(String iString)
			throws UnsupportedEncodingException {
		String oString = iString;
		if (iString != null)
			oString = new String(iString.getBytes("ISO8859_1"), "GBK");

		return oString;
	}

	public static String GBKToUnicode(String iString)
			throws UnsupportedEncodingException {
		String oString = iString;
		if (iString != null)
			oString = new String(iString.getBytes("GBK"), "ISO8859_1");

		return oString;
	}

	public static int getPos(String strMain, String strSub, int intTimes) {
		return getPos(strMain, strSub, 0, intTimes);
	}

	public static int getPos(String strMain, String strSub, int intStartIndex,
			int intTimes) {
		int intCounter = 0;
		int intPosition = intStartIndex;
		int intLength = strSub.length();

		if (intTimes <= 0)
			return -1;

		if (strMain.length() - 1 < intStartIndex)
			return -1;

		if (strSub.equals(""))
			return 0;

		while (intCounter < intTimes) {
			intPosition = strMain.indexOf(strSub, intPosition);
			if (intPosition == -1)
				return -1;

			++intCounter;
			intPosition += intLength;
		}

		return (intPosition - intLength);
	}

	public static void copyFile(String fromFile, String toFile)
			throws FileNotFoundException, IOException, Exception {
		FileInputStream in = new FileInputStream(fromFile);
		FileOutputStream out = new FileOutputStream(toFile);
		byte[] b = new byte[1024];
		int len;
		while ((len = in.read(b)) != -1) {

			out.write(b, 0, len);
		}
		out.close();
		in.close();
	}

	public static String replace(String strMain, String strFind,
			String strReplaceWith) {
		String strReturn = "";
		int intStartIndex = 0;
		int intEndIndex = 0;

		if ((strMain == null) || (strMain.equals("")))
			return "";

		while ((intEndIndex = strMain.indexOf(strFind, intStartIndex)) > -1) {
			strReturn = strReturn
					+ strMain.substring(intStartIndex, intEndIndex)
					+ strReplaceWith;
			intStartIndex = intEndIndex + strFind.length();
		}

		strReturn = strReturn
				+ strMain.substring(intStartIndex, strMain.length());
		return strReturn;
	}

	public static String decodeStr(String strMain, String strDelimiters,
			int intSerialNo) {
		int posStart = 0;
		int posEnd = 0;
		String strReturn = "";

		if (strMain.length() < strDelimiters.length())
			return "";

		posStart = getPos(strMain, strDelimiters, intSerialNo - 1);
		if (posStart == -1) {
			posStart = 0;
		} else {
			posStart += strDelimiters.length();
		}

		posEnd = getPos(strMain, strDelimiters, intSerialNo);
		if (posEnd == -1) {
			posEnd = 0;
		}

		strReturn = strMain.substring(posStart, posEnd);
		return strReturn;
	}

	public static Vector stringToVector(String strMessage, String delimiter,
			int intCount, Class cl) throws Exception {
		int intFieldNum = 0;
		Object object = null;
		Vector vec = new Vector();
		int intPosition = 0;
		Class[] parameters = { String.class };
		Method method = null;
		Field field = null;
		String[] therecord = { new String() };
		try {
			object = cl.newInstance();
			method = cl.getMethod("decode", parameters);
			field = cl.getField("FIELDNUM");
			intFieldNum = field.getInt(object);
			for (int i = 0; i < intCount; ++i) {
				object = cl.newInstance();
				intPosition = getPos(strMessage, delimiter, intFieldNum);
				therecord[0] = strMessage.substring(0, intPosition + 1);
				method.invoke(object, therecord);
				vec.addElement(object);
				strMessage = strMessage.substring(intPosition + 1);
			}
		} catch (Exception exception) {
			throw exception;
		}
		return vec;
	}

	public static String toHTMLFormat(String strInValue) {
		String strOutValue = "";

		for (int i = 0; i < strInValue.length(); ++i) {
			char c = strInValue.charAt(i);
			switch (c) {
			case '<':
				strOutValue = strOutValue + "&lt;";
				break;
			case '>':
				strOutValue = strOutValue + "&gt;";
				break;
			case '\n':
				strOutValue = strOutValue + "<br>";
				break;
			case '\r':
				break;
			case ' ':
				strOutValue = strOutValue + "&nbsp;";
				break;
			default:
				strOutValue = strOutValue + c;
			}
		}

		return strOutValue;
	}

	public static String encode(String strInValue) {
		String strOutValue = "";

		for (int i = 0; i < strInValue.length(); ++i) {
			char c = strInValue.charAt(i);
			switch (c) {
			case ':':
				strOutValue = strOutValue + "：";
				break;
			case '|':
				strOutValue = strOutValue + "┃";
				break;
			case '\n':
				strOutValue = strOutValue + "\\n";
				break;
			case '\r':
				strOutValue = strOutValue + "\\r";
				break;
			case '"':
				strOutValue = strOutValue + "\\\"";
				break;
			case '\'':
				strOutValue = strOutValue + "\\'";
				break;
			case '\b':
				strOutValue = strOutValue + "\\b";
				break;
			case '\t':
				strOutValue = strOutValue + "\\t";
				break;
			case '\f':
				strOutValue = strOutValue + "\\f";
				break;
			case '\\':
				strOutValue = strOutValue + "\\\\";
				break;
			case '<':
				strOutValue = strOutValue + "\\<";
				break;
			case '>':
				strOutValue = strOutValue + "\\>";
				break;
			default:
				strOutValue = strOutValue + c;
			}

		}

		return strOutValue;
	}

	public static String convertString(String strName, String strValue,
			String strSign) {
		String strReturn = "";
		if ((strValue == null) || (strValue.equals(""))) {
			return "";
		}

		if (strSign.equals(":")) {
			String strValueStart = "";
			String strValueEnd = "";
			int index = strValue.indexOf(58);
			if (index > -1) {
				strValueStart = strValue.substring(0, index);
				strValueEnd = strValue.substring(index + 1);
				strReturn = " and " + strName + " between '" + strValueStart
						+ "' and '" + strValueEnd + "' ";
			} else {
				return "";
			}
		} else if (strSign.equals("=")) {
			strReturn = " and " + strName + "='" + strValue + "' ";
		} else {
			strValue = replace(strValue, "*", "%");
			strReturn = " and " + strName + " like '%" + strValue + "%' ";
		}

		return strReturn;
	}

	public static String convertDate(String strName, String strValue,
			String strSign) {
		String strReturn = "";
		String strDbType = "ORACLE";

		if ((strValue == null) || (strValue.equals(""))) {
			return "";
		}

		if (strSign.equals(":")) {
			String strValueStart = "";
			String strValueEnd = "";
			int index = strValue.indexOf(58);
			if (index > -1) {
				strValueStart = strValue.substring(0, index);
				strValueEnd = strValue.substring(index + 1);
				if (strDbType.equals("ORACLE"))
					strReturn = " and " + strName + " between to_date('"
							+ strValueStart + "') and to_date('" + strValueEnd
							+ "') ";
				else
					strReturn = " and " + strName + " between '"
							+ strValueStart + "' and '" + strValueEnd + "' ";
			} else {
				return "";
			}

		} else if (strDbType.equals("ORACLE")) {
			strReturn = " and " + strName + strSign + "to_date('" + strValue
					+ "') ";
		} else {
			strReturn = " and " + strName + strSign + "'" + strValue + "' ";
		}

		return strReturn;
	}

	public static String convertNumber(String strName, String strValue,
			String strSign) {
		String strReturn = "";
		if ((strValue == null) || (strValue.equals(""))) {
			return "";
		}

		if (strSign.equals(":")) {
			String strValueStart = "";
			String strValueEnd = "";
			int index = strValue.indexOf(58);
			if (index > -1) {
				strValueStart = strValue.substring(0, index);
				strValueEnd = strValue.substring(index + 1);
				strReturn = " and " + strName + " between '" + strValueStart
						+ "' and '" + strValueEnd + "' ";
			} else {
				return "";
			}
		} else {
			strReturn = " and " + strName + strSign + "'" + strValue + "' ";
		}

		return strReturn;
	}

	public static String decode(String strInValue) {
		String strOutValue = strInValue;
		strOutValue = replace(strOutValue, "\\n", "\n");
		strOutValue = replace(strOutValue, "\\r", "\r");
		strOutValue = replace(strOutValue, "\\\\", "\\");
		strOutValue = replace(strOutValue, "\\b", "\b");
		strOutValue = replace(strOutValue, "\\t", "\t");
		strOutValue = replace(strOutValue, "\\\"", "\"");
		strOutValue = replace(strOutValue, "\\'", "'");
		strOutValue = replace(strOutValue, "\\f", "\f");
		strOutValue = replace(strOutValue, "\\<", "<");
		strOutValue = replace(strOutValue, "\\>", ">");
		return strOutValue;
	}

	public static Object split(String strMain, int intMaxLength) {
		if (strMain == null)
			return new String[0];

		if (strMain.trim().equals(""))
			return new String[0];

		byte[] arrByte = new byte[0];
		int intEndIndex = 0;
		int intStartIndex = 0;
		int intCount = 0;
		int j = 0;
		String[] arrReturn = new String[0];

		arrByte = strMain.getBytes();
		intCount = Math.round(arrByte.length / intMaxLength + 0.5F);
		arrReturn = new String[intCount];

		for (int i = 0; i < intCount; ++i) {
			if (intEndIndex == 0)
				intEndIndex = intMaxLength - 1;
			else
				intEndIndex += intMaxLength;

			intEndIndex = Math.min(intEndIndex, arrByte.length - 1);

			if (arrByte[intEndIndex] < 0) {
				j = intEndIndex - 1;
				do {
					if (arrByte[j] >= 0)
						break;
					--j;
				} while (j >= intStartIndex);

				if ((intEndIndex - j) % 2 != 0) {
					--intEndIndex;
				}
			}
			arrReturn[i] = new String(arrByte, intStartIndex, intEndIndex
					- intStartIndex + 1);
			if (intEndIndex == arrByte.length - 1)
				break;
			intStartIndex = intEndIndex + 1;
		}
		return arrReturn;
	}

	public static String chgStrZero(String iValue) {
		String value = null;

		if (iValue == null)
			value = "0";
		else if (iValue.trim().length() == 0)
			value = "0";
		else
			value = iValue;

		return value.trim();
	}

	public static String getYear() {
		String strReturn = "";
		int intYear = Calendar.getInstance().get(1);
		strReturn = "" + intYear;
		return strReturn;
	}

	public static String getMonth() {
		String strReturn = "";
		int intMonth = Calendar.getInstance().get(2) + 1;
		if (intMonth < 10)
			strReturn = "0" + intMonth;
		else
			strReturn = "" + intMonth;
		return strReturn;
	}

	public static String getDay() {
		String strReturn = "";
		int intDate = Calendar.getInstance().get(5);
		if (intDate < 10)
			strReturn = "0" + intDate;
		else
			strReturn = "" + intDate;

		return strReturn;
	}

	public static String getHour() {
		String strReturn = "";
		int intHour = Calendar.getInstance().get(10) + 12
				* Calendar.getInstance().get(9);
		if (intHour < 10)
			strReturn = "0" + intHour;
		else
			strReturn = "" + intHour;

		return strReturn;
	}

	public static String getMinute() {
		String strReturn = "";
		int intMinute = Calendar.getInstance().get(12);
		if (intMinute < 10)
			strReturn = "0" + intMinute;
		else
			strReturn = "" + intMinute;

		return strReturn;
	}

	public static String getSecond() {
		String strReturn = "";
		int intSecond = Calendar.getInstance().get(13);
		if (intSecond < 10)
			strReturn = "0" + intSecond;
		else
			strReturn = "" + intSecond;

		return strReturn;
	}

	public static String[] split(String strIn, String strDelimiters)
			throws Exception {
		int theIndex = 0;
		String[] arrReturn = null;
		String strErrorMessage = "";
		int intCount = 0;

		if ((strIn.equals("")) || (strIn == null) || (strDelimiters.equals(""))
				|| (strDelimiters == null)) {
			strErrorMessage = "Str.split('" + strIn + "','" + strDelimiters
					+ "'): 待拆分字符串和分隔符串都不能为空";
			throw new Exception(strErrorMessage);
		}

		if (strIn.length() < strDelimiters.length()) {
			strErrorMessage = "Str.split('" + strIn + "','" + strDelimiters
					+ "'): 待拆分字符串比分隔符串还要短";
			throw new Exception(strErrorMessage);
		}

		String strTemp = strIn;
		while ((strTemp != "") && (strTemp != null)) {
			theIndex = strTemp.indexOf(strDelimiters);
			if (theIndex == -1) {
				break;
			}
			++intCount;
			strTemp = strTemp.substring(theIndex + strDelimiters.length());
		}
		arrReturn = new String[++intCount];

		for (int i = 0; i < intCount - 1; ++i) {
			theIndex = strIn.indexOf(strDelimiters);
			arrReturn[i] = strIn.substring(0, theIndex);
			strIn = strIn.substring(theIndex + strDelimiters.length());
		}
		arrReturn[(intCount - 1)] = strIn;

		return arrReturn;
	}

	public static String rightTrim(String strIn) {
		String strReturn = "";
		int intLength = 0;

		if ((strIn == null) || (strIn.equals("")) || (strIn.equals("null")))
			return "";
		intLength = strIn.length();

		while ((intLength > 0)
				&& (strIn.substring(intLength - 1, intLength).equals(" "))) {
			strIn = strIn.substring(0, intLength - 1);
			intLength = strIn.length();
		}

		strReturn = strIn;
		return strReturn;
	}

	public static double round(double v, int scale) {
		BigDecimal b = new BigDecimal(Double.toString(v));

		BigDecimal one = new BigDecimal("1");

		return b.divide(one, scale, 4).doubleValue();
	}
	
	
	/**
	 * 字符串转ASCII
	 * 
	 * @param value
	 * @return
	 */
	public static String string2Ascii(String value) {
		if (value == null) {
			return "";
		}
		StringBuffer sbu = new StringBuffer();
		char[] chars = value.toCharArray();

		for (int i = 0; i < chars.length; i++) {
			if (i != chars.length - 1) {
				sbu.append((int) chars[i]).append("");
			} else {
				sbu.append((int) chars[i]);
			}
		}
		return sbu.toString().trim();
	}

	/**
	 * ascii转字符串
	 * 
	 * @param value
	 * @return
	 */
	public static String asciiToString(String value) {
		if (value == null) {
			return "";
		}
		StringBuffer sbu = new StringBuffer();
		String[] chars = value.split(",");
		for (int i = 0; i < chars.length; i++) {
			sbu.append((char) Integer.parseInt(chars[i]));
		}
		return sbu.toString();
	}

	/**
	 * 转16进制
	 * @param s
	 * @return
	 */
	public static String toHexString(String s) {
		String str = "";
		if (s == null) {
			return "";
		}
		for (int i = 0; i < s.length(); i++) {
			int ch = (int) s.charAt(i);
			String s4 = Integer.toHexString(ch);
			str = str + s4;
		}
		return str;
	}

	/**
	 * 字符串转ascii总和
	 * @param value
	 * @return
	 */
	public static int string2AsciiSum(String value) {
		if (value == null) {
			return 0;
		}
		StringBuffer sbu = new StringBuffer();
		char[] chars = value.toCharArray();

		for (int i = 0; i < chars.length; i++) {
			if (i != chars.length - 1) {
				sbu.append((int) chars[i]).append(",");
			} else {
				sbu.append((int) chars[i]);
			}
		}
		String[] tmp = sbu.toString().trim().split(",");
		int sum = 0;
		for (int i = 0; i < tmp.length; i++) {
			sum+=Integer.parseInt(tmp[i]);
		}
		return sum;
	}
	
	/**
	 * 根据规则分隔字符串
	 * @param value
	 * @param regex
	 * @return
	 */
	public static List<String> splitByRegex(String value,String regex){
		List<String> arrayList = new ArrayList<>();
		if (value == null) {
			return arrayList;
		}
		
		String[] result = value.split(regex);
		for (int i = 0; i < result.length; i++) {
			String string = result[i];
			if (string.equals("")) {
				continue;
			}
			arrayList.add(string);
		}
		
		return arrayList;
	}
	
	/**
	 * 按照,号分隔
	 * @param value
	 * @return
	 */
	public static List<String> splitByComma(String value){
		return splitByRegex(value, ",");
	}
	
	/**
	 * 按照#号分隔
	 * @param value
	 * @return
	 */
	public static List<String> splitBySharp(String value){
		return splitByRegex(value, "#");
	}

	/**
	 * 根据用户名的不同长度，来进行替换 ，达到保密效果
	 *
	 * @param userName 用户名
	 * @return 替换后的用户名
	 */
	public static String userNameReplaceWithStar(String userName) {
		String userNameAfterReplaced = "";

		if (userName == null){
			userName = "";
		}

		int nameLength = userName.length();

		if (nameLength <= 1) {
			userNameAfterReplaced = "*";
		} else if (nameLength == 2) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{0})\\d(?=\\d{1})","");
		} else if (nameLength >= 3 && nameLength <= 6) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{1})\\d(?=\\d{1})","");
		} else if (nameLength == 7) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{1})\\d(?=\\d{2})","");
		} else if (nameLength == 8) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{2})\\d(?=\\d{2})","");
		} else if (nameLength == 9) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{2})\\d(?=\\d{3})","");
		} else if (nameLength == 10) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{3})\\d(?=\\d{3})","");
		} else if (nameLength >= 11) {
			userNameAfterReplaced = replaceAction(userName, "(?<=\\d{3})\\d(?=\\d{4})","");
		}

		return userNameAfterReplaced;

	}

	/**
	 * 实际替换动作
	 * @param realStr  要替换的字符串
	 * @param regular  正则
	 * @param replaceStr  替换成怎样的字符，比如*
     * @return
     */
	private static String replaceAction(String realStr, String regular,String replaceStr) {
		if(StringUtils.isEmpty(replaceStr)){
			replaceStr="*";
		}
		return realStr.replaceAll(regular, replaceStr);
	}

	/**
	 * 身份证号替换，保留前四位和后四位
	 *
	 * 如果身份证号为空 或者 null ,返回null ；否则，返回替换后的字符串；
	 *
	 * @param idCard 身份证号
	 * @return
	 */
	public static String idCardReplaceWithStar(String idCard) {

		if (StringUtils.isEmpty(idCard)) {
			return null;
		} else {
			return replaceAction(idCard, "(?<=\\d{4})\\d(?=\\d{4})","*");
		}
	}

	/**
	 * 银行卡替换，保留后四位
	 *
	 * 如果银行卡号为空 或者 null ,返回null ；否则，返回替换后的字符串；
	 *
	 * @param bankCard 银行卡号
	 * @return
	 */
	public static String bankCardReplaceWithStar(String bankCard) {

		if (StringUtils.isEmpty(bankCard)) {
			return null;
		} else {
			return replaceAction(bankCard, "(?<=\\d{0})\\d(?=\\d{4})","*");
		}
	}

	/***
	 *
	 * @param replaceStr
	 * @param leftKeepDigits
	 * @param rightKeepDigits
	 * @param wantReplace
     * @return
     */
	public static String stringReplace(String replaceStr,int leftKeepDigits,int rightKeepDigits,String wantReplace) {

		String regular="(?<=\\w{"+leftKeepDigits+"})\\w(?=\\w{"+rightKeepDigits+"})";
		/**
		 * 如果字符长度，小于要替换的长度和，直接返回字符
		 */
		int strLength=replaceStr.length();
		int sumKeepDigits=leftKeepDigits+rightKeepDigits;
		if(strLength<=sumKeepDigits){
			return replaceStr;
		}
		if (StringUtils.isEmpty(replaceStr)) {
			return null;
		} else {
			return replaceAction(replaceStr, regular,wantReplace);
		}
	}

	/**
	 * 企业客户的名字关键字
	 */
	public static ArrayList<String> COMPANY_NAMES_KEYWORDS;
	static {
		COMPANY_NAMES_KEYWORDS = new ArrayList<>();
		COMPANY_NAMES_KEYWORDS.add("公司");
		COMPANY_NAMES_KEYWORDS.add("集团");
		COMPANY_NAMES_KEYWORDS.add("学校");
		COMPANY_NAMES_KEYWORDS.add("中学");
		COMPANY_NAMES_KEYWORDS.add("大学");
		COMPANY_NAMES_KEYWORDS.add("小学");
		COMPANY_NAMES_KEYWORDS.add("院");
		COMPANY_NAMES_KEYWORDS.add("所");
		COMPANY_NAMES_KEYWORDS.add("局");
		COMPANY_NAMES_KEYWORDS.add("厅");
		COMPANY_NAMES_KEYWORDS.add("办公室");
	}

	/**
	 * 判断字符串是否公司名
	 * @param str
	 * @return
	 */
	public static Boolean isCompanyName(String str) {
		Boolean result = false;
		Boolean minLenFlag = false;
		if(str.length() > 4) {
			minLenFlag = true;
		}
		for(String kw : COMPANY_NAMES_KEYWORDS) {
			if(str.contains(kw)) {
				result = minLenFlag;
			}
		}

		return result;
	}

	
}
