/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.encrypt.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sinosoftgz.utils.data.StandardCharset;
import sinosoftgz.utils.encrypt.EncryptHandler;

public abstract class AbstratEncryptHandler
implements EncryptHandler {
    protected abstract MessageDigest messageDigest() throws NoSuchAlgorithmException;

    @Override
    public String encrypt(String src, String salt, StandardCharset charset) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (src == null) {
            return null;
        }
        MessageDigest msgDigest = this.messageDigest();
        byte[] saltBytes = salt.getBytes(charset.value());
        byte[] byteArray = src.getBytes(charset.value());
        msgDigest.update(saltBytes);
        byte[] digestedBytes = msgDigest.digest(byteArray);
        return this.toHexString(digestedBytes);
    }

    protected String toHexString(byte[] bytes) {
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int val = bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
}

