package sinosoftgz.utils.io;


import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class ComCodeUtil {
    /**
     * 去掉机构末尾的0
     * @param comCode
     * @return
     */
    public static String getComcode(String comCode) {
        char[] data = comCode.toCharArray();
        for (int i = data.length - 1; i >=0; i--) {
            if(data[i] != '0'){
                return comCode.substring(0,i+1);
            }
        }
        return comCode;
    }

    /**
     * 根据当前机构，推导上级机构
     * @param comCode
     * @return
     */
    public static Queue<String> getComcodes(String comCode) {
        String[] c = new String[]{
                comCode.substring(0, 2),
                comCode.substring(2, 4),
                comCode.substring(4, 6),
                comCode.substring(6, 8)
        };
        Queue<String> queue = new LinkedList<String>();
        String tb = "";
        for (int i = 4; i >= 1; i--) {
            if (Integer.parseInt(c[i - 1]) > 0) {
                for (int j = 0; j < 4 - i; j++) {
                    tb += "00";
                }
                queue.offer(comCode.substring(0, (i - 1) * 2) + c[i - 1] + tb);
                tb = "";
            }
        }
        return  queue;
    }

    /**
     * 前端多选转后端in == {"aa,bb"} ->{'aa','bb'}
     **/
    public static String toIn(String inData){
        if(StringUtils.isEmpty(inData)){
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String [] comcodes = inData.split(",");
        if(comcodes.length == 1 && StringUtils.isNotBlank(comcodes[0])){
            stringBuffer.append("'").append(comcodes[0]).append("'");
            return stringBuffer.toString();
        }
        if(comcodes.length > 1){
            for (int i = 0; i < comcodes.length; i++) {
                if(StringUtils.isEmpty(comcodes[i])) continue;
                if(i == (comcodes.length-1)){
                    stringBuffer.append("'").append(comcodes[i]).append("'");
                    break;
                }
                stringBuffer.append("'").append(comcodes[i]).append("'").append(",");
            }
        }
        if(StringUtils.isEmpty(stringBuffer.toString()))
            return null;
        return stringBuffer.toString();
    }

    /**
     * 前端多选转后端in == {"aa,bb"} ->{'aa','bb'}
     **/
    public static List<String> toInList(String inData){
        if(StringUtils.isEmpty(inData)){
            return null;
        }
        List<String> ins = new ArrayList<>();
        String [] comcodes = inData.split(",");
        if(comcodes.length == 1 && StringUtils.isNotBlank(comcodes[0])){
            ins.add(comcodes[0]);
            return ins;
        }
        if(comcodes.length > 1){
            for (int i = 0; i < comcodes.length; i++) {
                if(StringUtils.isEmpty(comcodes[i])) continue;
                ins.add(comcodes[i]);
            }
        }
        if(null != ins && ins.size()>0)
            return ins;
        return null;
    }

    public static String toLikeStr(String comCode, int lavel) {
        if (org.apache.commons.lang3.StringUtils.isBlank(comCode)) {
            return null;
        }
        String[] strs = new String[]{
                comCode.substring(0, 2),
                comCode.substring(0, 4),
                comCode.substring(0, 6),
                comCode.substring(0, 8)
        };
        if (1 == lavel) {
            return strs[lavel-1];
        } else if (2 == lavel) {
            return strs[lavel-1];
        } else if (3 == lavel) {
            return strs[lavel-1];
        } else {
            return strs[3];
        }
    }

    public static void main(String[] args) {
        // 一段掩人耳目的注释 \u000d/*
        System.out.println("HelloWorld");
        // 一段掩人耳目的注释 \u000d*/
        Queue<String> comcodes = getComcodes("44010200");
        System.out.println(JSON.toJSON(comcodes));;
        if(comcodes.size() == 4){
            comcodes.poll();
        }
        System.out.println(JSON.toJSON(comcodes));;
    }
}
