/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Lang {
    private static final String DATE_FORMAT_YYYYMMDDHHMMSS_SSS = "yyyyMMddHHmmssSSS";
    public static final Object EMPTY = new Object();
    public static final Object[] EMPTY_ARRAY = new Object[0];

    private Lang() {
    }

    public static long identityHashCode(Object x) {
        return (long)System.identityHashCode(x) + Integer.MAX_VALUE;
    }

    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException unchecked(Throwable e, String message, Object ... args) {
        return new RuntimeException(String.format(message, args), e);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return obj.toString().trim().length() == 0;
        }
        if (obj.getClass().equals(Object.class)) {
            return true;
        }
        if (Lang.isBaseType(obj.getClass())) {
            return false;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return Object.class.equals(obj.getClass());
    }

    public static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.equals(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (Class.class.equals(type)) {
            return true;
        }
        if (StringBuilder.class.equals(type)) {
            return true;
        }
        if (StringBuffer.class.equals(type)) {
            return true;
        }
        if (Object.class.equals(type)) {
            return true;
        }
        return Void.class.equals(type);
    }

    public static boolean isNumber(Class<?> type) {
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.equals(Integer.TYPE)) {
            return true;
        }
        if (type.equals(Short.TYPE)) {
            return true;
        }
        if (type.equals(Long.TYPE)) {
            return true;
        }
        if (type.equals(Float.TYPE)) {
            return true;
        }
        if (type.equals(Double.TYPE)) {
            return true;
        }
        return type.equals(Byte.TYPE);
    }

    public static Throwable getCause(Throwable e) {
        return e.getCause() == null ? e : Lang.getCause(e.getCause());
    }

    public static String toString(Object obj) {
        return Lang.toString(obj, null);
    }

    public static String toString(Object obj, String format) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Throwable) {
            Throwable throwable = (Throwable)obj;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            pw.close();
            sw.flush();
            return sw.toString();
        }
        if (obj instanceof Date) {
            return new SimpleDateFormat(format == null || format.trim().length() == 0 ? DATE_FORMAT_YYYYMMDDHHMMSS_SSS : format).format((Date)obj);
        }
        if (Lang.isNumber(obj.getClass()) && format != null && format.trim().length() != 0) {
            return new DecimalFormat(format).format(obj);
        }
        return String.valueOf(obj);
    }

    public static <T> Set<T> newSet(T ... args) {
        int length = args == null ? 1 : args.length;
        HashSet<T> set = new HashSet<T>(length);
        if (args == null) {
            set.add(null);
        } else {
            for (int i = 0; i < args.length; ++i) {
                set.add(args[i]);
            }
        }
        return set;
    }

    public static <T> List<T> newList(T ... args) {
        int length = args == null ? 1 : args.length;
        ArrayList<T> list = new ArrayList<T>(length);
        if (args == null) {
            list.add(null);
        } else {
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i]);
            }
        }
        return list;
    }

    public static <T extends Throwable> T newThrowable(Class<T> type, String message, Object ... args) {
        try {
            return (T)((Throwable)type.getConstructor(String.class).newInstance(String.format(message, args)));
        }
        catch (InstantiationException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (IllegalAccessException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (IllegalArgumentException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (InvocationTargetException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (NoSuchMethodException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (SecurityException e) {
            throw Lang.unchecked(e, message, args);
        }
    }

    public static IllegalStateException newThrowable(String message, Object ... args) {
        return Lang.newThrowable(IllegalStateException.class, message, args);
    }

    public static <K, V> Map<K, V> newMap(Object ... args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("The number of arguments must be an even number");
            }
            for (int i = 0; i < args.length; i += 2) {
                map.put(args[i], args[i + 1]);
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> newLRUMap(final int capacity, Object ... args) {
        Map<K, V> map = Lang.newMap(args);
        return new LinkedHashMap<K, V>(map){
            private static final long serialVersionUID = -5820354698308020916L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > capacity;
            }
        };
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (Lang.isNumber(a.getClass()) && Lang.isNumber(b.getClass())) {
            return new BigDecimal(a.toString()).compareTo(new BigDecimal(b.toString())) == 0;
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).compareTo((Date)b) == 0;
        }
        return false;
    }

    public static long timing(Runnable runnable) {
        long begin = System.currentTimeMillis();
        try {
            runnable.run();
            return System.currentTimeMillis() - begin;
        }
        catch (Throwable e) {
            throw Lang.unchecked(e);
        }
    }

    public static void isTrue(boolean flag, String message, Object ... args) {
        if (!flag) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notNull(Object object, String message, Object ... args) {
        Lang.isTrue(object != null, message, args);
    }

    public static void notEmpty(Object object, String message, Object ... args) {
        Lang.isTrue(!Lang.isEmpty(object), message, args);
    }

    public static void main(String[] args) {
        System.out.println(BigDecimal.valueOf(0L).equals(0));
    }

    public static Throwable getMessageCause(Throwable e) {
        while (e != null && e.getMessage() == null && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }
}

