/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.log;

import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;
import sinosoftgz.utils.lang.Lang;

public class Log {
    private static final String FQCN = Log.class.getCanonicalName();
    static ILoggerFactory iLoggerFactory;
    LocationAwareLogger logger;
    String name;

    Log(String name) {
        this.name = name;
        try {
            this.logger = (LocationAwareLogger)LoggerFactory.getLogger((String)name);
        }
        catch (Exception e) {
            this.logger = (LocationAwareLogger)iLoggerFactory.getLogger(name);
        }
    }

    public String toString() {
        return "Log [name=" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(Throwable e, Object message, Object ... args) {
        if (this.isTraceEnabled()) {
            String msg = message == null ? "null" : message.toString();
            this.logger.log(null, FQCN, 0, msg, args, e);
        }
    }

    public void trace(Object message, Object ... args) {
        this.trace(null, message, args);
    }

    public void trace(Object message) {
        this.trace(message, Lang.EMPTY_ARRAY);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Throwable e, Object message, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = message == null ? "null" : message.toString();
            this.logger.log(null, FQCN, 10, msg, args, e);
        }
    }

    public void debug(Object message, Object ... args) {
        this.debug(null, message, args);
    }

    public void debug(Object message) {
        this.debug(message, Lang.EMPTY_ARRAY);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(Throwable e, Object message, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = message == null ? "null" : message.toString();
            this.logger.log(null, FQCN, 20, msg, args, e);
        }
    }

    public void info(Object message, Object ... args) {
        this.info(null, message, args);
    }

    public void info(Object message) {
        this.info(message, Lang.EMPTY_ARRAY);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(Throwable e, Object message, Object ... args) {
        if (this.isWarnEnabled()) {
            String msg = message == null ? "null" : message.toString();
            this.logger.log(null, FQCN, 30, msg, args, e);
        }
    }

    public void warn(Object message, Object ... args) {
        this.warn(null, message, args);
    }

    public void warn(Object message) {
        this.warn(message, Lang.EMPTY_ARRAY);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(Throwable e, Object message, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = message == null ? "null" : message.toString();
            this.logger.log(null, FQCN, 40, msg, args, e);
        }
    }

    public void error(Object message, Object ... args) {
        this.error(null, message, args);
    }

    public void error(Object message) {
        this.error(message, Lang.EMPTY_ARRAY);
    }
}

