package sinosoftgz.utils.data;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


/**
 * Excel导出工具（xlsx格式版本）
 * Created by Administrator on 2017-04-18.
 * 该类的使用方法为把该SET的SET完后运行doDerivedExcel（）就可以了
 */
public class DerivedExcelXlsx {
    /**
     * 预定义Excel单元格样式{@value}: 录入项，表示该列需要用户录入
     */
    public static final String CELL_STYLE_NEED_INPUT = "input";

    String fileName;//导出文件名
    Collection collection;//查询结果集合
    HttpServletResponse response;//response
    Map map;//必须new LinkedHashMap();

    public void setColStyleMap(Map colStyleMap) {
        this.colStyleMap = colStyleMap;
    }

    Map colStyleMap;//必须new LinkedHashMap();
    //MAP 例子 map.put("certino","代码"); certino为字段名 '代码'为certino中文名称做表头,MAP的设定必须按顺序
    Class dtoClass;//集合DTO类

    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static final int PERSHEET = 50000;//每个sheet数据量

    public DerivedExcelXlsx() {
        super();
    }

    /**
     *
     * @param fileName 导出文件名
     * @param collection 查询结果集合
     * @param response
     * @param map
     * @param dtoClass
     */
    public DerivedExcelXlsx(String fileName, Collection collection,
                            HttpServletResponse response, Map map, Class dtoClass) {
        super();
        this.fileName = fileName;
        this.collection = collection;
        this.response = response;
        this.map = map;
        this.dtoClass = dtoClass;
    }

    public void  doDerivedExcel() throws Exception{
        XSSFWorkbook workbook = new XSSFWorkbook();
        //设置每行
        setRows(workbook);
        inTOStream(workbook,response);

    }

    private void setRows(XSSFWorkbook workbook) throws Exception{
        XSSFSheet sheet = null;
        XSSFCell cell = null;
        int sheetCount = 0;
        XSSFRow row = null;
        //设置表头样式
        XSSFCellStyle cellStyle = setCellStyle(workbook);


        Map getDtoMap =  getAllSetter(dtoClass);//得到DTO对像的get方法
        Object object = dtoClass.newInstance();
        Class clazz = object.getClass();
        int t=0;
        Iterator dataIterator = collection.iterator();
        Set keySet = map.keySet();//按顺序取到设置的map的KEY
        Class returnType = null;
        Object returnValue = null;

        //设置单元格为"文本"格式
        XSSFCellStyle cellStyle2 = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        cellStyle2.setDataFormat(format.getFormat("@"));

        //设置单元格为"时间"格式
        XSSFCellStyle cellStyleDateTime = workbook.createCellStyle();
        XSSFDataFormat formatDateTime = workbook.createDataFormat();
        cellStyleDateTime.setDataFormat(formatDateTime.getFormat("yyyy-MM-dd HH:mm:ss"));

        //设置单元格为"货币"格式
        XSSFCellStyle cellStyle3 = workbook.createCellStyle();
        XSSFDataFormat format3 = workbook.createDataFormat();
        cellStyle3.setDataFormat(format3.getFormat("#,##0.00"));

        Map<String, XSSFCellStyle> cellStyles = new LinkedHashMap<>();
        XSSFCellStyle cellStyleInput = workbook.createCellStyle();
        cellStyleInput.setDataFormat(format.getFormat("@"));
//        cellStyleInput.set
        cellStyleInput.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        cellStyleInput.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyleInput.setBorderTop(BorderStyle.THIN);
        cellStyleInput.setBorderLeft(BorderStyle.THIN);
        cellStyleInput.setBorderBottom(BorderStyle.THIN);
        cellStyleInput.setBorderRight(BorderStyle.THIN);
        cellStyles.put(CELL_STYLE_NEED_INPUT, cellStyleInput);
        String cellStyleIdx = "";
        while(dataIterator.hasNext()){
            int i=0;

            sheetCount = t/PERSHEET;
            if(t==0||t%PERSHEET==0){//每五万条数据，换一个sheet页
                sheet = workbook.createSheet("data"+(sheetCount+1));
                row = sheet.createRow((short)0);
                //设置每列大小
                for(int ii=0;ii<map.size();ii++){
                    sheet.setColumnWidth((short) ii,(short) ((50 * 8) / ((double) 1 / 12)));
                }
                cell = setTitle(cell,cellStyle,row);
            }
            t++;

            object = (Object)dataIterator.next();
            row = sheet.createRow(t-sheetCount*PERSHEET);
            Iterator i2 = keySet.iterator();
            List<String> allMethods = Arrays.stream(clazz.getMethods()).map(Method::getName).collect(Collectors.toList());
            while(i2.hasNext()){
                cell = row.createCell((short)i);
                i++;
                String curKey = i2.next().toString();
                String strKey = "get"+curKey;
                String methodKey = ""+getDtoMap.get(strKey.toLowerCase());

                if(!StringUtils.isEmpty(methodKey) && allMethods.contains(methodKey)) {
                    Method m2 = clazz.getMethod(methodKey, null);//设置方法
                    returnType = m2.getReturnType();
                    returnValue = m2.invoke(object);
                    if(returnValue!=null){
                        if (returnType == Integer.class){
                            cell.setCellValue((Integer)returnValue);//得到返回参数。
                        }else if (returnType == Long.class){
                            cell.setCellValue(((Long)returnValue).toString());//得到返回参数。
                        }else if (returnType == Double.class){
                            cell.setCellValue((Double)returnValue);//得到返回参数。
                            //cell.setCellStyle(cellStyle3);
                        }else if (returnType == BigDecimal.class){
                            cell.setCellValue(((BigDecimal)returnValue).doubleValue());//得到返回参数。
                        }else if (returnType == String.class){
                            cell.setCellValue(""+returnValue);
                            cell.setCellStyle(cellStyle2);
                        }else if (returnType == Date.class ){
                            cell.setCellValue(""+returnValue);
                            cell.setCellStyle(cellStyleDateTime);
                        }else if (returnType == LocalDateTime.class){
                            cell.setCellValue(""+returnValue);
                            cell.setCellStyle(cellStyleDateTime);
                        }else{
                            cell.setCellValue(""+returnValue);//得到返回参数。
                        }
                    }
                }


                // 样式
                if(this.colStyleMap != null) {
                    cellStyleIdx = (String) this.colStyleMap.get(curKey);
                    if(!StringUtils.isEmpty(cellStyleIdx)) {
                        if(cellStyles.get(cellStyleIdx) != null) {
                            cell.setCellStyle(cellStyles.get(cellStyleIdx));
                        }
                    }
                }
            }
        }
    }





    private XSSFCell setTitle(XSSFCell cell, XSSFCellStyle cellStyle, XSSFRow row) {
        // TODO 自动生成方法存根
        Set s1= map.keySet();
        Collection c1 = map.values();
        Iterator it =  c1.iterator();
        int itInt =0;
        while(it.hasNext()){
            cell = row.createCell((short)itInt);
            itInt++;
            cell.setCellValue(""+it.next());//每列参数
            cell.setCellStyle(cellStyle);//设定样式
        }
        return cell;
    }


    private void inTOStream(XSSFWorkbook workbook, HttpServletResponse response) throws Exception {
        // TODO 自动生成方法存根
        File downFile=new File(fileName+".xlsx");
        response.setHeader("Content-Disposition", "attachment; filename=" + new String(downFile.getName().getBytes("gb2312"),"iso8859-1"));
        ServletOutputStream sos = response.getOutputStream();
        workbook.write(sos);

        sos.flush();
    }


    private static Map getAllSetter(Class cl) {
        Map methodMap = new HashMap();
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get")) {
                continue;
            }
            //System.out.println(method.getReturnType());
            //System.out.println(methodName);
            methodMap.put(methodName.toLowerCase(), methodName);
        }
        while (true) {//无限查找他的父类
            cl = cl.getSuperclass();
            if (cl == Object.class) {//到了Object类终止
                break;
            }
            methodMap.putAll(getAllSetter(cl));
        }
        return methodMap;
    }

    private XSSFCellStyle setCellStyle(XSSFWorkbook workbook){
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        //单元格边框
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        // 水平对齐方式
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }



    public void setCollection(Collection collection) {
        this.collection = collection;
    }
    public void setDtoClass(Class dtoClass) {
        this.dtoClass = dtoClass;
    }
    public void setMap(Map map) {
        this.map = map;
    }
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

}
