package sinosoftgz.utils.data;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.*;

/**
 * 图片DataUrl处理工具
 * Created by lindexin on 2016/6/16.
 */
public class ImageDataUrlUtil {

    public static final  String PREFIX_PNG = "data:image/png;base64,";
    public static final  String PREFIX_JPG= "data:image/jpg;base64,";

    /**
     * @Descriptionmap 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
     * @param path 图片路径
     * @return
     */
    public static String imageToBase64(String path) {// 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        byte[] data = null;
        // 读取图片字节数组
        try {
            InputStream in = new FileInputStream(path);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        // 返回Base64编码过的字节数组字符串
        return encoder.encode(data);
    }

    /**
     * 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
     * @param inputStream 文件流
     * @return
     */
    public static String imageToBase64(InputStream inputStream) {// 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        byte[] data = null;
        // 读取图片字节数组
        try {
            data = new byte[inputStream.available()];
            inputStream.read(data);
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        // 返回Base64编码过的字节数组字符串
        return encoder.encode(data);
    }

    /**
     * 解析DataUrl生成图片文件
     * @Descriptionmap 对字节数组字符串进行Base64解码并生成图片
     * @param base64 图片Base64数据
     * @param path 图片路径
     * @return
     */
    public static String base64ToImage(String base64, String path) {// 对字节数组字符串进行Base64解码并生成图片
        // 图像数据为空
        if (base64 == null){
            return path;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            // Base64解码
            byte[] bytes = decoder.decodeBuffer(base64);
            for (int i = 0; i < bytes.length; ++i) {
                // 调整异常数据
                if (bytes[i] < 0) {
                    bytes[i] += 256;
                }
            }
            // 生成jpeg图片
            OutputStream out = new FileOutputStream(path);
            out.write(bytes);
            out.flush();
            out.close();
            return path;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }
}
