package sinosoftgz.utils.encrypt;

import sinosoftgz.utils.data.StandardCharset;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

/**
 * @author Liang Wenxu
 * @since 2018/12/18
 */
public interface EncryptHandler {
    String DIGEST_INSTANCE_MD5 = "MD5";
    String DIGEST_INSTANCE_SHA1 = "SHA";
    String DIGEST_INSTANCE_SHA256 = "SHA-256";
    String DIGEST_INSTANCE_SHA512 = "SHA-512";

    /**
     * 执行加密
     * @param src 原字符串
     * @param salt 加密盐
     * @param charset 字符集
     * @return 返回加密后的字符串
     * @throws UnsupportedEncodingException
     */
    String encrypt(String src, String salt, StandardCharset charset) throws UnsupportedEncodingException, NoSuchAlgorithmException;
}
