package com.sinosoftgz.starter.sms.core.aop;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.sms.core.biz.SmsLogBiz;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import com.sinosoftgz.starter.sms.log.storage.core.properties.SmsLogStorageProperties;
import lombok.extern.slf4j.Slf4j;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;


/**
 * @author: Roney
 * @date: 2022-05-16 18:11
 * @description: 发送短信日志切面
 */
@Configuration
@Aspect
@Slf4j
@ConditionalOnProperty(prefix = SmsLogStorageProperties.SMS_LOG_STORAGE_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class SmsLogStorageAspect {

    @Resource
    SmsLogBiz smsLogBiz;

    private final String ADD_POINT_CUT
            = " (execution(* com.sinosoftgz.starter.sms.core.handler..*.*(..))&& args(javaSmsClientReq))";

    @Before("saveSendSmsLog(javaSmsClientReq)")
    public void sendSmsLogCall(JavaSmsClientReq javaSmsClientReq) {
        log.debug("send sms log ! javaSmsClientReq:{}", JSON.toJSONString(javaSmsClientReq));
        try {
            smsLogBiz.saveSendSmsLog(javaSmsClientReq);
        } catch (Exception e) {
            log.error("保存日志记录异常", e);
        }
    }

    @Pointcut(ADD_POINT_CUT)
    public void saveSendSmsLog(JavaSmsClientReq javaSmsClientReq) {
    }
}
